/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import gov.nasa.jpf.util.Growth;

public class ExpGrowth
implements Growth {
    final float factor;
    final float sqFactor;
    final int plus;

    public ExpGrowth(float factor, int plus) {
        if (factor < 1.001f || factor > 100.0f) {
            throw new IllegalArgumentException();
        }
        this.factor = factor;
        this.sqFactor = (float)Math.sqrt(factor);
        this.plus = plus;
    }

    public ExpGrowth(float factor) {
        this(factor, 7);
    }

    @Override
    public int grow(int oldSize, int minNewSize) {
        int newSize = (int)(this.factor * (float)oldSize) + this.plus;
        if (newSize < minNewSize) {
            newSize = (int)(this.sqFactor * (float)minNewSize) + this.plus;
        }
        return newSize;
    }
}

