/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import gov.nasa.jpf.util.Growth;
import java.util.Iterator;

public final class DynamicIntArray
implements Iterable<Integer> {
    static final int DEFAULT_CHUNKBITS = 8;
    static final int INIT_CHUNKS = 16;
    Growth growth;
    int chunkBits;
    int nPerChunk;
    int chunkMask;
    int[][] data;
    int maxIndex = -1;

    public DynamicIntArray() {
        this(Growth.defaultGrowth, 8, 16);
    }

    public DynamicIntArray(int size) {
        this(Growth.defaultGrowth, 8, (size + 256 - 1) / 256);
    }

    public DynamicIntArray(int chunkBits, int initChunks) {
        this(Growth.defaultGrowth, chunkBits, initChunks);
    }

    public DynamicIntArray(Growth strategy, int chunkBits, int initChunks) {
        if (chunkBits > 20) {
            throw new IllegalArgumentException();
        }
        this.chunkBits = chunkBits;
        this.nPerChunk = 1 << chunkBits;
        this.chunkMask = this.nPerChunk - 1;
        this.data = new int[initChunks][];
        this.growth = strategy;
    }

    public int get(int index) {
        int i = index >> this.chunkBits;
        if (i < this.data.length && this.data[i] != null) {
            int j = index & this.chunkMask;
            return this.data[i][j];
        }
        return 0;
    }

    public int size() {
        return this.data.length * this.nPerChunk;
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public void set(int index, int value) {
        if (index > this.maxIndex) {
            this.maxIndex = index;
        }
        int i = index >> this.chunkBits;
        int j = index & this.chunkMask;
        if (i >= this.data.length) {
            int nChunks = this.growth.grow(this.data.length, i + 1);
            int[][] newChunks = new int[nChunks][];
            System.arraycopy(this.data, 0, newChunks, 0, this.data.length);
            this.data = newChunks;
        }
        if (this.data[i] == null) {
            this.data[i] = new int[this.nPerChunk];
        }
        this.data[i][j] = value;
    }

    public String toString() {
        int length;
        for (length = this.data.length * this.nPerChunk; length > 1 && this.get(length - 1) == 0; --length) {
        }
        StringBuilder sb = new StringBuilder(length);
        sb.append('{');
        int l = length - 1;
        for (int i = 0; i < l; ++i) {
            sb.append(this.get(i));
            sb.append(',');
        }
        sb.append(this.get(l));
        sb.append('}');
        return sb.toString();
    }

    @Override
    public Iterator<Integer> iterator() {
        return new DynIntIterator();
    }

    class DynIntIterator
    implements Iterator<Integer> {
        int i;

        DynIntIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < DynamicIntArray.this.size();
        }

        @Override
        public Integer next() {
            return new Integer(DynamicIntArray.this.get(this.i++));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

