/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.ListenerAdapter;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.ALOAD;
import gov.nasa.jpf.jvm.bytecode.ArrayStoreInstruction;
import gov.nasa.jpf.jvm.bytecode.FieldInstruction;
import gov.nasa.jpf.jvm.bytecode.GETFIELD;
import gov.nasa.jpf.jvm.bytecode.GETSTATIC;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.StoreInstruction;
import gov.nasa.jpf.jvm.bytecode.VariableAccessor;
import gov.nasa.jpf.search.Search;
import gov.nasa.jpf.tools.VarChange;
import gov.nasa.jpf.tools.VarStat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class VarTracker
extends ListenerAdapter {
    int changeThreshold = 1;
    boolean filterSystemVars = false;
    String classFilter = null;
    ArrayList<VarChange> queue = new ArrayList();
    ThreadInfo lastThread;
    HashMap<String, VarStat> stat = new HashMap();
    int nStates = 0;
    int maxDepth;

    void print(int n, int length) {
        String s = Integer.toString(n);
        int l = length - s.length();
        for (int i = 0; i < l; ++i) {
            System.out.print(' ');
        }
        System.out.print(s);
    }

    void report(String message) {
        VarStat s;
        int n;
        System.out.println("VarTracker results:");
        System.out.println("           states:        " + this.nStates);
        System.out.println("           max depth:     " + this.maxDepth);
        System.out.println("           term reason:   " + message);
        System.out.println();
        System.out.println("           minChange:     " + this.changeThreshold);
        System.out.println("           filterSysVars: " + this.filterSystemVars);
        if (this.classFilter != null) {
            System.out.println("           classFilter:   " + this.classFilter);
        }
        System.out.println();
        System.out.println("      change    variable");
        System.out.println("---------------------------------------");
        Collection<VarStat> values = this.stat.values();
        ArrayList<VarStat> valueList = new ArrayList<VarStat>();
        valueList.addAll(values);
        Collections.sort(valueList);
        Iterator it = valueList.iterator();
        while (it.hasNext() && (n = (s = (VarStat)it.next()).getChangeCount()) >= this.changeThreshold) {
            this.print(s.nChanges, 12);
            System.out.print("    ");
            System.out.println(s.id);
        }
    }

    @Override
    public void stateAdvanced(Search search) {
        if (search.isNewState()) {
            int stateId = search.getStateNumber();
            ++this.nStates;
            int depth = search.getDepth();
            if (depth > this.maxDepth) {
                this.maxDepth = depth;
            }
            if (!this.queue.isEmpty()) {
                for (VarChange change : this.queue) {
                    String id = change.getVariableId();
                    VarStat s = this.stat.get(id);
                    if (s == null) {
                        s = new VarStat(id, stateId);
                        this.stat.put(id, s);
                        continue;
                    }
                    if (s.lastState == stateId) continue;
                    ++s.nChanges;
                    s.lastState = stateId;
                }
            }
        }
        this.queue.clear();
    }

    @Override
    public void propertyViolated(Search search) {
        this.report("property violated");
    }

    @Override
    public void searchConstraintHit(Search search) {
        this.report("search constraint hit");
        System.exit(0);
    }

    @Override
    public void searchFinished(Search search) {
        this.report("search finished");
    }

    @Override
    public void instructionExecuted(JVM jvm) {
        Instruction insn = jvm.getLastInstruction();
        ThreadInfo ti = jvm.getLastThreadInfo();
        if ((insn instanceof GETFIELD || insn instanceof GETSTATIC) && ((FieldInstruction)insn).isReferenceField() || insn instanceof ALOAD) {
            Object ei;
            int objRef = ti.peek();
            if (objRef != -1 && ((ElementInfo)(ei = DynamicArea.getHeap().get(objRef))).isArray()) {
                String varId = ((VariableAccessor)((Object)insn)).getVariableId();
                ti.setOperandAttr(varId);
            }
        } else if (insn instanceof StoreInstruction) {
            Object attr;
            String varId = insn instanceof ArrayStoreInstruction ? ((attr = ti.getOperandAttr(-1)) != null ? attr.toString() + "[]" : "?[]") : ((VariableAccessor)((Object)insn)).getVariableId();
            if (this.filterChange(varId)) {
                this.queue.add(new VarChange(varId));
                this.lastThread = ti;
            }
        }
    }

    boolean filterChange(String varId) {
        if (this.filterSystemVars) {
            if (varId.startsWith("java.")) {
                return false;
            }
            if (varId.startsWith("javax.")) {
                return false;
            }
            if (varId.startsWith("sun.")) {
                return false;
            }
        }
        if (this.classFilter != null && !varId.startsWith(this.classFilter)) {
            return false;
        }
        for (int i = 0; i < this.queue.size(); ++i) {
            VarChange change = this.queue.get(i);
            if (!change.getVariableId().equals(varId)) continue;
            return false;
        }
        return true;
    }

    void filterArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            if (args[i].equals("-noSystemVars")) {
                this.filterSystemVars = true;
                args[i] = null;
                continue;
            }
            if (args[i].equals("-minChange")) {
                args[i++] = null;
                if (i >= args.length) continue;
                this.changeThreshold = Integer.parseInt(args[i]);
                args[i] = null;
                continue;
            }
            if (!args[i].equals("-classFilter")) continue;
            args[i++] = null;
            if (i >= args.length) continue;
            this.classFilter = args[i];
            args[i] = null;
        }
    }

    static void printUsage() {
        System.out.println("VarTracker - a JPF listener tool to report how often variables changed");
        System.out.println("             at least once in every state (to detect state space holes)");
        System.out.println("usage: java gov.nasa.jpf.tools.VarTracker <jpf-options> <varTracker-options> <class>");
        System.out.println("       -noSystemVars : don't report system variable changes (java*)");
        System.out.println("       -minChange <num> : don't report variables with less than <num> changes");
        System.out.println("       -classFilter <string> : only report changes in classes starting with <string>");
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            VarTracker.printUsage();
            return;
        }
        VarTracker listener = new VarTracker();
        listener.filterArgs(args);
        Config conf = JPF.createConfig(args);
        JPF jpf = new JPF(conf);
        jpf.addSearchListener(listener);
        jpf.addVMListener(listener);
        jpf.run();
    }
}

