/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.ListenerAdapter;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.InvokeInstruction;
import gov.nasa.jpf.search.Search;
import gov.nasa.jpf.util.StringSetMatcher;

public class TraceStorer
extends ListenerAdapter {
    int nTrace = 1;
    String traceFileName;
    boolean storeMultiple;
    boolean terminateOnStore;
    int storeDepth;
    StringSetMatcher storeCalls;
    StringSetMatcher storeThreads;
    Search search;
    JVM vm;

    public TraceStorer(Config config, JPF jpf) {
        this.traceFileName = config.getString("trace.file", "trace");
        this.storeMultiple = config.getBoolean("trace.multiple", false);
        this.storeDepth = config.getInt("trace.depth", Integer.MAX_VALUE);
        this.terminateOnStore = config.getBoolean("trace.terminate", false);
        this.storeCalls = StringSetMatcher.getNonEmpty(config.getStringArray("trace.store_calls"));
        this.storeThreads = StringSetMatcher.getNonEmpty(config.getStringArray("trace.store_threads"));
        this.vm = jpf.getVM();
        this.search = jpf.getSearch();
    }

    void storeTrace(String reason) {
        String fname = this.traceFileName;
        if (this.storeMultiple) {
            fname = fname + '.' + this.nTrace++;
        }
        this.vm.storeTrace(fname, reason);
    }

    @Override
    public void propertyViolated(Search search) {
        this.storeTrace("violated property: " + search.getLastError().getDetails());
    }

    @Override
    public void stateAdvanced(Search search) {
        if (search.getDepth() >= this.storeDepth) {
            this.storeTrace("search depth reached: " + this.storeDepth);
            this.checkSearchTermination();
        }
    }

    @Override
    public void instructionExecuted(JVM vm) {
        Instruction insn;
        if (this.storeCalls != null && (insn = vm.getLastInstruction()) instanceof InvokeInstruction) {
            InvokeInstruction iinsn = (InvokeInstruction)insn;
            String clsName = iinsn.getInvokedMethodClassName();
            String mthName = iinsn.getInvokedMethodName();
            String mn = clsName + '.' + mthName;
            if (this.storeCalls.matchesAny(mn)) {
                this.storeTrace("call: " + mn);
                this.checkVMTermination();
            }
        }
    }

    @Override
    public void threadStarted(JVM vm) {
        ThreadInfo ti;
        String tname;
        if (this.storeThreads != null && this.storeThreads.matchesAny(tname = (ti = vm.getLastThreadInfo()).getName())) {
            this.storeTrace("thread started: " + tname);
            this.checkVMTermination();
        }
    }

    boolean checkVMTermination() {
        if (this.terminateOnStore) {
            this.vm.getLastThreadInfo().breakTransition();
            this.search.terminate();
            return true;
        }
        return false;
    }

    boolean checkSearchTermination() {
        if (this.terminateOnStore) {
            this.search.terminate();
            return true;
        }
        return false;
    }
}

