/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.search.Search;
import gov.nasa.jpf.search.SearchListener;

public class TimeConstrainedJPF
implements SearchListener {
    static long maxTime = 0L;
    static long startTime = 0L;

    @Override
    public void searchStarted(Search search) {
        JVM vm = search.getVM();
        Config config = vm.getConfig();
        startTime = System.currentTimeMillis();
        maxTime = config.getInt("jpf.time_limit", -1);
        System.out.println("****TIME BOUNDED SEARCH - LIMIT SET TO (SECONDS): " + maxTime + " ****");
        maxTime *= 1000L;
    }

    @Override
    public void stateAdvanced(Search search) {
        long duration = System.currentTimeMillis() - startTime;
        if (duration >= maxTime) {
            System.out.println("****TIME BOUNDED SEARCH - TOTAL TIME (SECONDS): " + (duration /= 1000L) + " ****");
            search.terminate();
        }
    }

    @Override
    public void searchFinished(Search search) {
    }

    @Override
    public void searchConstraintHit(Search search) {
    }

    @Override
    public void stateBacktracked(Search search) {
    }

    @Override
    public void stateProcessed(Search search) {
    }

    @Override
    public void stateStored(Search search) {
    }

    @Override
    public void stateRestored(Search search) {
    }

    @Override
    public void propertyViolated(Search search) {
    }
}

