/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.Error;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.ListenerAdapter;
import gov.nasa.jpf.jvm.Step;
import gov.nasa.jpf.jvm.Transition;
import gov.nasa.jpf.search.Search;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class StateSpaceDot
extends ListenerAdapter {
    static final int RECTANGLE = 1;
    static final int ELLIPSE = 2;
    static final int ROUND_RECTANGLE = 3;
    static final int RECTANGLE_WITH_TEXT = 4;
    static final int ELLIPSE_WITH_TEXT = 5;
    static final int ROUND_RECTANGLE_WITH_TEXT = 6;
    private static final String DOT_EXT = "dot";
    private static final String GDF_EXT = "gdf";
    private static final String OUT_FILENAME_NO_EXT = "jpf-state-space";
    private static final int state_node_style = 5;
    private static final int transition_node_style = 4;
    private static final int DOT_FORMAT = 0;
    private static final int GDF_FORMAT = 1;
    private BufferedWriter graph = null;
    private int edge_id = 0;
    private static boolean transition_numbers = false;
    private static boolean show_source = false;
    private static int format = 0;
    private String out_filename = "jpf-state-space.dot";
    private static boolean labelvisible = false;
    private static boolean helpRequested = false;
    ArrayList<String> gdfEdges = new ArrayList();
    private StateInformation prev_state = null;

    @Override
    public void searchStarted(Search search) {
        try {
            this.beginGraph();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void searchFinished(Search search) {
        try {
            this.endGraph();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void stateAdvanced(Search search) {
        int id = search.getStateNumber();
        boolean has_next = search.hasNextState();
        boolean is_new = search.isNewState();
        try {
            if (format == 0) {
                this.graph.write("/* searchAdvanced(" + id + ", " + this.makeDotLabel(search, id) + ", " + has_next + ") */");
                this.graph.newLine();
            }
            if (this.prev_state != null) {
                this.addEdge(this.prev_state.id, id, search);
            } else {
                this.prev_state = new StateInformation();
            }
            this.addNode(this.prev_state);
            this.prev_state.reset(id, has_next, is_new);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @Override
    public void stateRestored(Search search) {
        this.prev_state.reset(search.getStateNumber(), false, false);
    }

    @Override
    public void stateProcessed(Search search) {
    }

    @Override
    public void stateBacktracked(Search search) {
        try {
            this.addNode(this.prev_state);
            this.prev_state.reset(search.getStateNumber(), false, false);
            if (format == 0) {
                this.graph.write("/* searchBacktracked(" + this.prev_state + ") */");
                this.graph.newLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void searchConstraintHit(Search search) {
        try {
            if (format == 0) {
                this.graph.write("/* searchConstraintHit(" + search.getStateNumber() + ") */");
                this.graph.newLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getErrorMsg(Search search) {
        List<Error> errs = search.getErrors();
        if (errs.isEmpty()) {
            return null;
        }
        return errs.get(0).getDescription();
    }

    @Override
    public void propertyViolated(Search search) {
        try {
            this.prev_state.error = this.getErrorMsg(search);
            if (format == 0) {
                this.graph.write("/* propertyViolated(" + search.getStateNumber() + ") */");
                this.graph.newLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void beginGraph() throws IOException {
        this.graph = new BufferedWriter(new FileWriter(this.out_filename));
        if (format == 1) {
            this.graph.write("nodedef>name,label,style,color");
        } else {
            this.graph.write("digraph jpf_state_space {");
        }
        this.graph.newLine();
    }

    private void endGraph() throws IOException {
        this.addNode(this.prev_state);
        if (format == 1) {
            this.graph.write("edgedef>node1,node2,label,labelvisible,directed,thread INT");
            this.graph.newLine();
            int size = this.gdfEdges.size();
            for (int i = 0; i < size; ++i) {
                this.graph.write(this.gdfEdges.get(i));
                this.graph.newLine();
            }
        } else {
            this.graph.write("}");
            this.graph.newLine();
        }
        this.graph.close();
    }

    private String makeDotLabel(Search state, int my_id) {
        String source_line;
        Transition trans = state.getTransition();
        if (trans == null) {
            return "-init-";
        }
        StringBuilder result = new StringBuilder();
        if (transition_numbers) {
            result.append(my_id);
            result.append("\\n");
        }
        Step last_trans_step = trans.getLastStep();
        int thread = trans.getThreadIndex();
        result.append("Thd");
        result.append(thread);
        result.append(':');
        result.append(last_trans_step.getSourceRef().toString());
        if (show_source && (source_line = last_trans_step.getSourceRef().getLineString()) != null && !source_line.equals("")) {
            result.append("\\n");
            StringBuilder sb = new StringBuilder(source_line);
            this.replaceString(sb, "\n", "");
            this.replaceString(sb, "]", "\\]");
            this.replaceString(sb, "\"", "\\\"");
            result.append(sb.toString());
        }
        return result.toString();
    }

    private String makeGdfLabel(Search state, int my_id) {
        String source_line;
        Transition trans = state.getTransition();
        if (trans == null) {
            return "-init-";
        }
        StringBuilder result = new StringBuilder();
        if (transition_numbers) {
            result.append(my_id);
            result.append(':');
        }
        Step last_trans_step = trans.getLastStep();
        result.append(last_trans_step.getSourceRef().toString());
        if (show_source && (source_line = last_trans_step.getSourceRef().getLineString()) != null && !source_line.equals("")) {
            result.append(source_line);
            this.convertGdfSpecial(result);
        }
        return result.toString();
    }

    private StringBuilder replaceString(StringBuilder original, String from, String to) {
        int indexOfReplaced = 0;
        int lastIndexOfReplaced = 0;
        while (indexOfReplaced != -1) {
            indexOfReplaced = original.indexOf(from, lastIndexOfReplaced);
            if (indexOfReplaced == -1) continue;
            original.replace(indexOfReplaced, indexOfReplaced + 1, to);
            lastIndexOfReplaced = indexOfReplaced + to.length();
        }
        return original;
    }

    private String replaceString(String original, String from, String to) {
        if (original != null && from != null && to != null) {
            return this.replaceString(new StringBuilder(original), from, to).toString();
        }
        return original;
    }

    private void addNode(StateInformation state) throws IOException {
        if (state.is_new) {
            if (format == 1) {
                this.graph.write("st" + state.id + ",\"" + state.id);
                if (state.error != null) {
                    this.graph.write(":" + state.error);
                }
                this.graph.write("\",5");
                if (state.error != null) {
                    this.graph.write(",red");
                } else if (state.has_next) {
                    this.graph.write(",black");
                } else {
                    this.graph.write(",green");
                }
            } else {
                this.graph.write("  st" + state.id + " [label=\"" + state.id);
                if (state.error != null) {
                    this.graph.write(":" + state.error);
                }
                this.graph.write("\",shape=");
                if (state.error != null) {
                    this.graph.write("diamond,color=red");
                } else if (state.has_next) {
                    this.graph.write("circle,color=black");
                } else {
                    this.graph.write("egg,color=green");
                }
                this.graph.write("];");
            }
            this.graph.newLine();
        }
    }

    private String makeGdfEdgeString(String from_id, String to_id, String label, int thread) {
        StringBuilder sb = new StringBuilder(from_id);
        sb.append(',').append(to_id).append(',').append('\"');
        if (label != null && !"".equals(label)) {
            sb.append(label);
        } else {
            sb.append('-');
        }
        sb.append('\"').append(',').append(labelvisible).append(',').append(true).append(',').append(thread);
        this.replaceString(sb, "\n", "");
        return sb.toString();
    }

    private String convertGdfSpecial(String str) {
        if (str == null || "".equals(str)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(str);
        this.convertGdfSpecial(sb);
        return sb.toString();
    }

    private void convertGdfSpecial(StringBuilder sb) {
        this.replaceString(sb, "\"", "''");
        this.replaceString(sb, "\n", " ");
    }

    private void addEdge(int old_id, int new_id, Search state) throws IOException {
        int my_id = this.edge_id++;
        if (format == 1) {
            Transition trans = state.getTransition();
            int thread = trans.getThreadIndex();
            this.gdfEdges.add(this.makeGdfEdgeString("st" + old_id, "tr" + my_id, this.makeGdfLabel(state, my_id), thread));
            this.graph.write("tr" + my_id + ",\"" + my_id + "\"," + 4);
            this.graph.newLine();
            String lastOutputLabel = this.replaceString(this.convertGdfSpecial(trans.getOutput()), "\"", "''");
            this.gdfEdges.add(this.makeGdfEdgeString("tr" + my_id, "st" + new_id, lastOutputLabel, thread));
        } else {
            this.graph.write("  st" + old_id + " -> tr" + my_id + ";");
            this.graph.newLine();
            this.graph.write("  tr" + my_id + " [label=\"" + this.makeDotLabel(state, my_id) + "\",shape=box]");
            this.graph.newLine();
            this.graph.write("  tr" + my_id + " -> st" + new_id + ";");
        }
    }

    static void showUsage() {
        System.out.println("Usage: \"java [<vm-options>] gov.nasa.jpf.tools.StateSpaceDot [<graph-options>] [<jpf-options-and-args>]");
        System.out.println("  <graph-options> : ");
        System.out.println("    -gdf:                Generate the graph in GDF format. The default is DOT.");
        System.out.println("    -transition-numbers: Include transition numbers in transition labels.");
        System.out.println("    -show-source:        Include source lines in transition labels.");
        System.out.println("    -labelvisible:       Indicates if the label on the transitions is visible (used only with the -gdf option)");
        System.out.println("    -help:               Prints this help information and stops.");
        System.out.println("  <jpf-options-and-args>:");
        System.out.println("    Options and command line arguments passed directly to JPF.");
        System.out.println("  Note: With -gdf option transition edges could also include program output ");
        System.out.println("  but in order to enable this JPF's vm.path_output option must be set to ");
        System.out.println("  true.");
    }

    void filterArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            String arg = args[i];
            if ("-transition-numbers".equals(arg)) {
                transition_numbers = true;
                args[i] = null;
                continue;
            }
            if ("-show-source".equals(arg)) {
                show_source = true;
                args[i] = null;
                continue;
            }
            if ("-gdf".equals(arg)) {
                format = 1;
                this.out_filename = "jpf-state-space.gdf";
                args[i] = null;
                continue;
            }
            if ("-labelvisible".equals(arg)) {
                labelvisible = true;
                args[i] = null;
                continue;
            }
            if (!"-help".equals(args[i])) continue;
            StateSpaceDot.showUsage();
            helpRequested = true;
        }
    }

    public static void main(String[] args) {
        StateSpaceDot listener = new StateSpaceDot();
        System.out.println("JPF State Space dot Graph Generator");
        listener.filterArgs(args);
        System.out.println("...graph output to " + listener.out_filename + "...");
        if (helpRequested) {
            return;
        }
        Config conf = JPF.createConfig(args);
        JPF jpf = new JPF(conf);
        jpf.addSearchListener(listener);
        System.out.println("...running JPF...");
        jpf.run();
    }

    private static class StateInformation {
        int id = -1;
        boolean has_next = true;
        String error = null;
        boolean is_new = false;

        public void reset(int id, boolean has_next, boolean is_new) {
            this.id = id;
            this.has_next = has_next;
            this.error = null;
            this.is_new = is_new;
        }
    }
}

