/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.ListenerAdapter;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.search.Search;
import gov.nasa.jpf.util.ObjVector;
import java.util.logging.Logger;

public class SimpleIdleFilter
extends ListenerAdapter {
    static Logger log = JPF.getLogger("gov.nasa.jpf.tools.SimpleIdleFilter");
    ObjVector<ThreadStat> threadStats = new ObjVector();
    ThreadStat ts;
    int maxBackJumps;

    public SimpleIdleFilter(Config config) {
        this.maxBackJumps = config.getInt("idle.max_backjumps", 1);
    }

    @Override
    public void stateAdvanced(Search search) {
        this.ts.backJumps = 0;
        this.ts.loopStackDepth = 0;
        this.ts.loopEndPc = 0;
        this.ts.loopStartPc = 0;
    }

    @Override
    public void stateBacktracked(Search search) {
        this.ts.backJumps = 0;
        this.ts.loopStackDepth = 0;
        this.ts.loopEndPc = 0;
        this.ts.loopStartPc = 0;
    }

    @Override
    public void instructionExecuted(JVM jvm) {
        Instruction insn = jvm.getLastInstruction();
        ThreadInfo ti = jvm.getLastThreadInfo();
        int tid = ti.getIndex();
        this.ts = this.threadStats.get(tid);
        if (this.ts == null) {
            this.ts = new ThreadStat(ti.getName());
            this.threadStats.set(tid, this.ts);
        }
        if (insn.isBackJump()) {
            ++this.ts.backJumps;
            int loopStackDepth = ti.countStackFrames();
            int loopPc = jvm.getNextInstruction().getPosition();
            if (loopStackDepth != this.ts.loopStackDepth || loopPc != this.ts.loopStartPc) {
                this.ts.loopStackDepth = loopStackDepth;
                this.ts.loopStartPc = loopPc;
                this.ts.loopEndPc = insn.getPosition();
                this.ts.backJumps = 0;
            } else if (this.ts.backJumps > this.maxBackJumps) {
                ti.reschedule(true);
            }
        }
    }

    static class ThreadStat {
        String tname;
        int backJumps;
        int loopStartPc;
        int loopEndPc;
        int loopStackDepth;

        ThreadStat(String tname) {
            this.tname = tname;
        }
    }
}

