/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.ListenerAdapter;
import gov.nasa.jpf.search.Search;
import gov.nasa.jpf.search.heuristic.HeuristicSearch;
import java.io.PrintStream;

public class SearchStats
extends ListenerAdapter {
    PrintStream out = System.out;
    long time;
    long startTime;
    long startFreeMemory;
    int searchLevel = 0;
    int maxSearchLevel = 0;
    int newStates;
    int endStates;
    int backtracks;
    int revisitedStates;
    int processedStates;
    int restoredStates;
    int steps;
    long maxMemory;
    long totalMemory;
    long freeMemory;
    boolean isHeuristic = false;
    int queueSize = 0;
    int currentHeapCount = 0;
    int maxHeapCount = 0;

    @Override
    public void stateAdvanced(Search search) {
        this.steps += search.getTransition().getStepCount();
        if (this.isHeuristic) {
            this.queueSize = ((HeuristicSearch)search).getQueueSize();
        }
        if (search.isNewState()) {
            this.searchLevel = search.getDepth();
            if (this.searchLevel > this.maxSearchLevel) {
                this.maxSearchLevel = this.searchLevel;
            }
            ++this.newStates;
            this.currentHeapCount = search.getVM().getKernelState().da.count();
            if (this.currentHeapCount > this.maxHeapCount) {
                this.maxHeapCount = this.currentHeapCount;
            }
            if (search.isEndState()) {
                ++this.endStates;
            }
        } else {
            ++this.revisitedStates;
        }
    }

    @Override
    public void stateProcessed(Search search) {
        ++this.processedStates;
    }

    @Override
    public void stateBacktracked(Search search) {
        this.searchLevel = search.getDepth();
        ++this.backtracks;
    }

    @Override
    public void stateRestored(Search search) {
        this.searchLevel = search.getDepth();
        ++this.restoredStates;
    }

    @Override
    public void propertyViolated(Search search) {
    }

    @Override
    public void searchStarted(Search search) {
        if (search instanceof HeuristicSearch) {
            this.isHeuristic = true;
        }
        this.startTime = System.currentTimeMillis();
        Runtime rt = Runtime.getRuntime();
        this.startFreeMemory = rt.freeMemory();
        this.totalMemory = rt.totalMemory();
        this.maxMemory = rt.maxMemory();
    }

    @Override
    public void searchConstraintHit(Search search) {
    }

    void reportRuntime() {
        long td = this.time - this.startTime;
        int h = (int)(td / 3600000L);
        int m = (int)(td / 60000L) % 60;
        int s = (int)(td / 1000L) % 60;
        this.out.print("  abs time:          ");
        if (h < 10) {
            this.out.print('0');
        }
        this.out.print(h);
        this.out.print(':');
        if (m < 10) {
            this.out.print('0');
        }
        this.out.print(m);
        this.out.print(':');
        if (s < 10) {
            this.out.print('0');
        }
        this.out.print(s);
        this.out.print("  (");
        this.out.print(td);
        this.out.println(" ms)");
    }

    @Override
    public void searchFinished(Search search) {
        this.report("------ Search statistics: ------");
    }

    void report(String header) {
        this.time = System.currentTimeMillis();
        this.out.println(header);
        this.reportRuntime();
        this.out.println();
        this.out.print("  search depth:      ");
        this.out.print(this.searchLevel);
        this.out.print(" (max: ");
        this.out.print(this.maxSearchLevel);
        this.out.println(")");
        this.out.print("  new states:        ");
        this.out.println(this.newStates);
        this.out.print("  revisited states:  ");
        this.out.println(this.revisitedStates);
        this.out.print("  end states:        ");
        this.out.println(this.endStates);
        this.out.print("  backtracks:        ");
        this.out.println(this.backtracks);
        this.out.print("  processed states:  ");
        this.out.print(this.processedStates);
        this.out.print(" (");
        double d = (double)this.backtracks / (double)this.processedStates;
        int n = (int)d;
        int m = (int)((d - (double)n) * 10.0);
        this.out.print(n);
        this.out.print('.');
        this.out.print(m);
        this.out.println(" bt/proc state)");
        this.out.print("  restored states:   ");
        this.out.println(this.restoredStates);
        if (this.isHeuristic) {
            this.out.print("  queue size:        ");
            this.out.println(this.queueSize);
        }
        this.out.println();
        this.out.print("  total memory [kB]: ");
        this.out.print(this.totalMemory / 1024L);
        this.out.print(" (max: ");
        this.out.print(this.maxMemory / 1024L);
        this.out.println(")");
        this.out.print("  free memory [kB]:  ");
        this.out.println(this.freeMemory / 1024L);
        this.out.print("  max heap objects:  ");
        this.out.print(this.maxHeapCount);
        this.out.println();
    }
}

