/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.PropertyListenerAdapter;
import gov.nasa.jpf.jvm.AnnotationInfo;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.InfoObject;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.PUTFIELD;
import gov.nasa.jpf.jvm.bytecode.VirtualInvocation;
import gov.nasa.jpf.search.Search;
import gov.nasa.jpf.util.StringSetMatcher;
import java.io.PrintWriter;
import java.util.HashMap;

public class ObjectTracker
extends PropertyListenerAdapter {
    PrintWriter out = new PrintWriter(System.out, true);
    StringSetMatcher includes;
    StringSetMatcher excludes;
    boolean logLife;
    boolean logCall;
    boolean logPut;
    boolean logShared;
    boolean checkShared;
    boolean checkConst;
    HashMap<Integer, Record> trackedObjects;
    Violation violation;

    public ObjectTracker(Config conf, JPF jpf) {
        this.includes = StringSetMatcher.getNonEmpty(conf.getStringArray("ot.include"));
        this.excludes = StringSetMatcher.getNonEmpty(conf.getStringArray("ot.exclude"));
        this.logLife = conf.getBoolean("ot.log_life", true);
        this.logCall = conf.getBoolean("ot.log_call", true);
        this.logPut = conf.getBoolean("ot.log_put", true);
        this.logShared = conf.getBoolean("ot.log_shared", true);
        this.checkShared = conf.getBoolean("ot.check_shared", false);
        this.checkConst = conf.getBoolean("ot.check_const", false);
        this.trackedObjects = new HashMap();
    }

    boolean isTrackedClass(String clsName) {
        return StringSetMatcher.isMatch(clsName, this.includes, this.excludes);
    }

    boolean isTrackedObject(int ref) {
        return this.trackedObjects.containsKey(ref);
    }

    Record getRecord(int ref) {
        return this.trackedObjects.get(ref);
    }

    void log(ThreadInfo ti, String fmt, Object ... args) {
        this.out.print(ti.getIndex());
        this.out.print(": ");
        this.out.printf(fmt, args);
        this.out.println();
    }

    boolean checkShared(Record rec, ThreadInfo ti, InfoObject use, Instruction insn) {
        AnnotationInfo ai;
        if (this.checkShared && (ai = rec.ei.getClassInfo().getAnnotation("gov.nasa.jpf.NonShared")) != null && ti != rec.tiCreate) {
            this.violation = new Violation(rec, ti, use, insn);
            this.violation.setSharedErrorMessage();
            ti.breakTransition();
            return false;
        }
        return true;
    }

    boolean checkConst(Record rec, ThreadInfo ti, FieldInfo fi, Instruction insn) {
        AnnotationInfo ai;
        if (this.checkConst && (ai = insn.getMethodInfo().getAnnotation("gov.nasa.jpf.Const")) != null) {
            this.violation = new Violation(rec, ti, fi, insn);
            this.violation.setConstErrorMessage();
            ti.breakTransition();
            return false;
        }
        return true;
    }

    @Override
    public boolean check(Search search, JVM vm) {
        return this.violation == null;
    }

    @Override
    public void reset() {
        this.violation = null;
    }

    @Override
    public String getErrorMessage() {
        if (this.violation != null) {
            return this.violation.msg;
        }
        return null;
    }

    @Override
    public void objectCreated(JVM vm) {
        ElementInfo ei = vm.getLastElementInfo();
        ClassInfo ci = ei.getClassInfo();
        if (this.isTrackedClass(ci.getName())) {
            ThreadInfo ti = vm.getLastThreadInfo();
            this.trackedObjects.put(ei.getIndex(), new Record(ei, ti));
            if (this.logLife) {
                this.log(ti, "created %1$s", ei);
            }
        }
    }

    @Override
    public void objectReleased(JVM vm) {
        ElementInfo ei = vm.getLastElementInfo();
        int ref = ei.getIndex();
        if (this.isTrackedObject(ref)) {
            this.trackedObjects.remove(ref);
            if (this.logLife) {
                this.log(vm.getLastThreadInfo(), "released %1$s", ei);
            }
        }
    }

    @Override
    public void instructionExecuted(JVM vm) {
        PUTFIELD storeInsn;
        int ref;
        Record rec;
        ThreadInfo ti = vm.getLastThreadInfo();
        Instruction insn = vm.getLastInstruction();
        if (insn instanceof VirtualInvocation) {
            VirtualInvocation call;
            int ref2;
            Record rec2;
            if (vm.getNextInstruction() != insn && (rec2 = this.getRecord(ref2 = (call = (VirtualInvocation)insn).getThis(ti))) != null) {
                MethodInfo mi = call.getInvokedMethod(ti, ref2);
                if (this.logCall) {
                    this.log(ti, "invoke %1$s.%2$s", rec2.ei, mi.getUniqueName());
                }
                if (!this.checkShared(rec2, ti, mi, insn)) {
                    return;
                }
            }
        } else if (insn instanceof PUTFIELD && (rec = this.getRecord(ref = (storeInsn = (PUTFIELD)insn).getLastThis())) != null) {
            FieldInfo fi = storeInsn.getFieldInfo();
            if (this.logPut) {
                this.log(ti, "put %1$s.%2$s = <%3$d>", rec.ei, fi.getName(), storeInsn.getLastValue());
            }
            if (!this.checkShared(rec, ti, fi, insn)) {
                return;
            }
            if (!this.checkConst(rec, ti, fi, insn)) {
                return;
            }
        }
    }

    class Violation {
        Record rec;
        String msg;
        ThreadInfo tiUse;
        InfoObject use;
        Instruction insn;

        Violation(Record rec, ThreadInfo tiUse, InfoObject use, Instruction insn) {
            this.rec = rec;
            this.tiUse = tiUse;
            this.use = use;
            this.insn = insn;
        }

        public void setSharedErrorMessage() {
            StringBuilder sb = new StringBuilder("@NonShared object violation: ");
            sb.append(this.rec.ei);
            sb.append("\n\tcreated in thread: ");
            sb.append(this.rec.tiCreate.getName());
            sb.append("\n\tused in thread:    ");
            sb.append(this.tiUse.getName());
            sb.append("\n\tmethod:            ");
            sb.append(this.insn.getSourceLocation());
            this.msg = sb.toString();
        }

        public void setConstErrorMessage() {
            MethodInfo mi = this.insn.getMethodInfo();
            StringBuilder sb = new StringBuilder("@Const method violation: ");
            sb.append(mi.getFullName());
            sb.append("\n\tfield:    ");
            sb.append(((FieldInfo)this.use).getFullName());
            sb.append("\n\tmethod:   ");
            sb.append(this.insn.getSourceLocation());
            this.msg = sb.toString();
        }
    }

    static class Record {
        ElementInfo ei;
        ThreadInfo tiCreate;

        Record(ElementInfo ei, ThreadInfo ti) {
            this.ei = ei;
            this.tiCreate = ti;
        }
    }
}

