/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.ListenerAdapter;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.INVOKESPECIAL;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.InvokeInstruction;
import gov.nasa.jpf.jvm.bytecode.VirtualInvocation;
import gov.nasa.jpf.search.Search;
import java.io.PrintWriter;

public class MethodTracker
extends ListenerAdapter {
    static final String INDENT = "  ";
    MethodInfo lastMi;
    PrintWriter out = new PrintWriter(System.out, true);

    public MethodTracker(Config conf, JPF jpf) {
    }

    void logMethodCall(ThreadInfo ti, MethodInfo mi, int stackDepth) {
        this.out.print(ti.getIndex());
        this.out.print(":");
        for (int i = 0; i < stackDepth; ++i) {
            this.out.print(INDENT);
        }
        if (mi.isMJI()) {
            this.out.print("native ");
        }
        this.out.print(mi.getCompleteName());
        if (ti.isFirstStepInsn()) {
            this.out.print("...");
        }
        this.out.println();
    }

    @Override
    public void executeInstruction(JVM vm) {
        Instruction insn = vm.getLastInstruction();
        MethodInfo mi = insn.getMethodInfo();
        ThreadInfo ti = vm.getLastThreadInfo();
        if (mi != this.lastMi) {
            this.logMethodCall(ti, mi, ti.getStack().size());
            this.lastMi = mi;
        } else if (insn instanceof InvokeInstruction) {
            MethodInfo callee;
            if (insn instanceof VirtualInvocation) {
                VirtualInvocation callInsn = (VirtualInvocation)insn;
                int objref = callInsn.getThis(ti);
                callee = callInsn.getInvokedMethod(ti, objref);
            } else if (insn instanceof INVOKESPECIAL) {
                INVOKESPECIAL callInsn = (INVOKESPECIAL)insn;
                callee = callInsn.getInvokedMethod(ti);
            } else {
                InvokeInstruction callInsn = (InvokeInstruction)insn;
                callee = callInsn.getInvokedMethod(ti);
            }
            if (callee != null) {
                if (callee.isMJI()) {
                    this.logMethodCall(ti, callee, ti.getStack().size() + 1);
                }
            } else {
                this.out.println("ERROR: unknown callee of: " + insn);
            }
        }
    }

    @Override
    public void stateRestored(Search search) {
        int id = search.getStateNumber();
        this.out.println("----------------------------------- [" + search.getDepth() + "] restored: " + id);
    }

    @Override
    public void searchStarted(Search search) {
        this.out.println("----------------------------------- search started");
    }

    @Override
    public void stateAdvanced(Search search) {
        int id = search.getStateNumber();
        this.out.print("----------------------------------- [" + search.getDepth() + "] forward: " + id);
        if (search.isNewState()) {
            this.out.print(" new");
        } else {
            this.out.print(" visited");
        }
        if (search.isEndState()) {
            this.out.print(" end");
        }
        this.out.println();
        this.lastMi = null;
    }

    @Override
    public void stateBacktracked(Search search) {
        int id = search.getStateNumber();
        this.lastMi = null;
        this.out.println("----------------------------------- [" + search.getDepth() + "] backtrack: " + id);
    }

    @Override
    public void searchFinished(Search search) {
        this.out.println("----------------------------------- search finished");
    }
}

