/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.Test;
import gov.nasa.jpf.test.ArgList;
import gov.nasa.jpf.test.FieldReference;
import gov.nasa.jpf.test.Goal;
import gov.nasa.jpf.test.TestContext;
import gov.nasa.jpf.test.TestException;
import gov.nasa.jpf.test.TestSpec;
import gov.nasa.jpf.test.TestSpecLexer;
import gov.nasa.jpf.test.TestSpecParser;
import gov.nasa.jpf.test.ValSet;
import gov.nasa.jpf.util.StringSetMatcher;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;

public class MethodTester {
    static final ArgList EMPTY_ARGS = new ArgList(new ValSet[0]);
    String[] mthPatterns;
    StringSetMatcher mthMatcher;
    PrintWriter err;
    PrintWriter log = new PrintWriter(System.out, true);
    TestContext tctx;
    Class<?> targetCls;
    Constructor[] targetCtors;
    int nTotalMth;
    int nTestMth;
    int nTests;
    int nOk;
    int nFailure;
    int nMalformed;

    public MethodTester(String[] args) {
        this.err = new PrintWriter(System.err, true);
        if (args.length == 0) {
            this.showUsage();
        } else {
            this.targetCls = this.loadClass(args[0]);
            if (this.targetCls != null) {
                this.targetCtors = this.targetCls.getDeclaredConstructors();
                this.tctx = new TestContext(this.targetCls, this.log, this.err);
                if (args.length > 1) {
                    this.mthPatterns = new String[args.length - 1];
                    System.arraycopy(args, 1, this.mthPatterns, 0, this.mthPatterns.length);
                    this.mthMatcher = new StringSetMatcher(this.mthPatterns);
                }
            }
        }
    }

    void error(String msg) {
        this.err.println("@ ERROR " + msg);
    }

    void log(String msg) {
        this.log.println("@ " + msg);
    }

    Class<?> loadClass(String clsName) {
        try {
            Class<?> cls = Class.forName(clsName);
            return cls;
        }
        catch (ClassNotFoundException cnfx) {
            this.error("class \"" + clsName + "\" not found");
            return null;
        }
    }

    Constructor getCtor(ArgList args) {
        for (Constructor ctor : this.targetCtors) {
            if (!this.argsCompatible(ctor.getParameterTypes(), args)) continue;
            ctor.setAccessible(true);
            return ctor;
        }
        ++this.nMalformed;
        this.error("no suitable constructor");
        return null;
    }

    boolean isTypeCompatible(Class<?> p, Class<?> a) {
        if (p == a) {
            return true;
        }
        return a == Integer.class ? p == Integer.TYPE : (a == Long.class ? p == Long.TYPE : (a == Double.class ? p == Double.TYPE : (a == Boolean.class ? p == Boolean.TYPE : (a == Byte.class ? p == Byte.TYPE : (a == Character.class ? p == Character.TYPE : (a == Short.class ? p == Short.TYPE : (a == Float.class ? p == Float.TYPE : p.isAssignableFrom(a))))))));
    }

    boolean argsCompatible(Class<?>[] pTypes, ArgList args) {
        Class<?>[] aTypes = args.getArgTypes();
        if (aTypes.length == pTypes.length) {
            for (int i = 0; i < aTypes.length; ++i) {
                if (this.isTypeCompatible(pTypes[i], aTypes[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    boolean returnTypeCompatible(Method m, Goal g) {
        Class<?> gType = g.getGoalType();
        if (g != null) {
            Class<?> rType = m.getReturnType();
            return this.isTypeCompatible(rType, gType);
        }
        return true;
    }

    String argsToString(Object[] args) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(args[i]);
        }
        sb.append(')');
        return sb.toString();
    }

    boolean resolveFieldReferences(Object[] mthArgs) {
        for (int i = 0; i < mthArgs.length; ++i) {
            if (!(mthArgs[i] instanceof FieldReference)) continue;
            FieldReference fr = (FieldReference)mthArgs[i];
            Object val = this.tctx.getFieldValue(fr);
            if (val == null) {
                ++this.nMalformed;
                this.error("cannot get field value for: " + fr.getId());
                return false;
            }
            mthArgs[i] = val;
        }
        return true;
    }

    boolean makeArgsCompatible(Object[] args, Class<?>[] pTypes) {
        if (args.length != pTypes.length) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            Object a = TestContext.getCompatibleObject(args[i], pTypes[i]);
            if (a == null) {
                ++this.nMalformed;
                this.error("incompatible argument: " + args[i] + ", expected " + pTypes[i].getName());
                return false;
            }
            args[i] = a;
        }
        return true;
    }

    public TestContext getTestContext() {
        return this.tctx;
    }

    public void fail(String msg) {
        ++this.nFailure;
        if (msg != null) {
            this.log("FAILURE: " + msg + '\n');
        } else {
            this.log("FAILURE\n");
        }
    }

    public void malformed(String msg) {
        ++this.nMalformed;
        this.error(msg);
    }

    void execute(Method m, Object tgt, Object[] ctorArgs, Object[] mthArgs, Goal goal) {
        Object ret = null;
        Throwable ex = null;
        ++this.nTests;
        if (!this.preCheck(goal, m)) {
            return;
        }
        if (tgt != null) {
            this.log("execute: " + this.targetCls.getSimpleName() + this.argsToString(ctorArgs) + '.' + m.getName() + this.argsToString(mthArgs));
        } else {
            this.log("execute static: " + m.getName() + this.argsToString(mthArgs));
        }
        try {
            if (this.resolveFieldReferences(mthArgs)) {
                if (!this.makeArgsCompatible(mthArgs, m.getParameterTypes())) {
                    return;
                }
            } else {
                return;
            }
            ret = goal.execute(this, m, tgt, mthArgs);
            this.log("returns: " + this.getLiteral(ret));
            this.postCheck(goal, m, ret, ex);
        }
        catch (IllegalAccessException iax) {
            this.error("illegal access");
            return;
        }
        catch (InvocationTargetException t) {
            ex = t.getCause();
            this.log("throws: " + ex);
        }
    }

    boolean preCheck(Goal goal, Method m) {
        if (goal == null) {
            return false;
        }
        try {
            if (!goal.preCheck(this.tctx, m)) {
                ++this.nFailure;
                this.log("FAILURE\n");
                return false;
            }
        }
        catch (TestException tx) {
            ++this.nMalformed;
            this.error(tx.getMessage());
        }
        return true;
    }

    void postCheck(Goal goal, Method m, Object ret, Throwable ex) {
        Class<?> gType = goal.getGoalType();
        Object r = ret;
        if (gType != null && (r = TestContext.getCompatibleObject(ret, gType)) == null) {
            ++this.nMalformed;
            this.error("incompatible return object: " + ret.getClass().getName());
            return;
        }
        try {
            if (goal.postCheck(this.tctx, m, r, ex)) {
                ++this.nOk;
                this.log("Ok\n");
            } else {
                ++this.nFailure;
                this.log("FAILURE\n");
            }
        }
        catch (TestException ox) {
            ++this.nMalformed;
            this.error(ox.getMessage());
        }
    }

    String getLiteral(Object o) {
        String s = o == null ? "null" : (o instanceof String ? "\"" + o + '\"' : o.toString());
        return s;
    }

    void test(Method m, TestSpec tspec) {
        m.setAccessible(true);
        for (Goal goal : tspec.getGoals()) {
            this.log("goal: " + goal);
            if (Modifier.isStatic(m.getModifiers())) {
                for (Object[] mthArgs : tspec.getCallArgCombinations()) {
                    this.execute(m, null, null, mthArgs, goal);
                }
                continue;
            }
            List<ArgList> tgtArgs = tspec.getTargetArgs();
            if (tgtArgs.isEmpty()) {
                tgtArgs = new ArrayList<ArgList>();
                tgtArgs.add(EMPTY_ARGS);
            }
            for (ArgList ta : tgtArgs) {
                Constructor ctor = this.getCtor(ta);
                if (ctor == null) continue;
                for (Object[] ctorArgs : ta.getArgCombinations()) {
                    this.tctx.setTargetObject(null);
                    if (!this.resolveFieldReferences(ctorArgs) || !this.makeArgsCompatible(ctorArgs, ctor.getParameterTypes())) continue;
                    try {
                        Object tgt = ctor.newInstance(ctorArgs);
                        this.tctx.setTargetObject(tgt);
                        for (Object[] mthArgs : tspec.getCallArgCombinations()) {
                            this.execute(m, tgt, ctorArgs, mthArgs, goal);
                        }
                    }
                    catch (Throwable t) {
                        ++this.nMalformed;
                        this.error("instantiating target: " + t + " for args: " + this.argsToString(ctorArgs));
                    }
                }
            }
        }
    }

    TestSpec parseTestSpec(String spec) {
        ANTLRStringStream input = new ANTLRStringStream(spec);
        TestSpecLexer lexer = new TestSpecLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        TestSpecParser parser = new TestSpecParser((TokenStream)tokens, new PrintWriter(System.err, true), this.tctx);
        try {
            TestSpec tspec = parser.testspec();
            return tspec;
        }
        catch (RecognitionException rx) {
            ++this.nMalformed;
            this.error("spec did not parse: " + (Object)((Object)rx));
            return null;
        }
        catch (TestException tx) {
            this.error(tx.getMessage());
            return null;
        }
    }

    void showUsage() {
        System.err.println("usage: \"java gov.nasa.jpf.test.MethodTester <clsName>\"");
    }

    void showBanner() {
        this.log("MethodTester - run @Test expressions, v1.0");
        this.log("target class:   " + this.targetCls.getName());
        if (this.mthPatterns != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.mthPatterns.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.mthPatterns[i]);
            }
            this.log("test methods: " + sb);
        }
        this.log("==================================== tests:");
    }

    void showStatistics() {
        this.log("==================================== statistics:");
        this.log("tested methods: " + this.nTestMth + " of " + this.nTotalMth);
        this.log("tests:          " + this.nTests);
        this.log("passed:         " + this.nOk);
        if (this.nMalformed > 0) {
            this.log("MALFORMED:      " + this.nMalformed);
        }
        if (this.nFailure > 0) {
            this.log("FAILED:         " + this.nFailure);
        }
    }

    public void run() {
        this.showBanner();
        for (Method m : this.targetCls.getDeclaredMethods()) {
            Test t;
            ++this.nTotalMth;
            if (this.mthMatcher != null && !this.mthMatcher.matchesAny(m.getName()) || (t = m.getAnnotation(Test.class)) == null) continue;
            this.log("---- testing method: " + m);
            ++this.nTestMth;
            for (String s : t.value()) {
                this.log("test spec: \"" + s + "\"");
                this.log("");
                TestSpec tspec = this.parseTestSpec(s);
                if (tspec == null) continue;
                this.test(m, tspec);
            }
            this.log("");
        }
        this.showStatistics();
    }

    Class<?> getTargetCls() {
        return this.targetCls;
    }

    public static void main(String[] args) {
        MethodTester tester = new MethodTester(args);
        if (tester.getTargetCls() != null) {
            tester.run();
        }
    }
}

