/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.ListenerAdapter;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.search.Search;

public class InsnCounter
extends ListenerAdapter {
    String[] opCodes = new String[500];
    int[] counts = new int[500];
    int total;

    @Override
    public void searchFinished(Search search) {
        this.reportStatistics();
    }

    @Override
    public void instructionExecuted(JVM jvm) {
        Instruction insn = jvm.getLastInstruction();
        int bc = insn.getByteCode();
        if (this.opCodes[bc] == null) {
            this.opCodes[bc] = insn.getMnemonic();
        }
        int n = bc;
        this.counts[n] = this.counts[n] + 1;
        ++this.total;
    }

    void reportStatistics() {
        int[] sorted = this.getSortedCounts();
        int total = 0;
        for (int i = 0; i < sorted.length; ++i) {
            int idx = sorted[i];
            String opc = this.opCodes[idx];
            if (this.counts[idx] <= 0) break;
            System.out.print(i);
            System.out.print("  ");
            System.out.print(opc);
            System.out.print(" : ");
            System.out.println(this.counts[idx]);
            total += this.counts[idx];
        }
        System.out.println();
        System.out.println("total number of executed instructions: " + total);
    }

    int[] getSortedCounts() {
        int[] sorted = new int[256];
        int last = -1;
        for (int i = 0; i < 256; ++i) {
            int c = this.counts[i];
            if (c <= 0) continue;
            for (int j = 0; j < last; ++j) {
                if (this.counts[sorted[j]] >= c) continue;
                System.arraycopy(sorted, j, sorted, j + 1, last - j);
                break;
            }
            sorted[j] = i;
            ++last;
        }
        return sorted;
    }

    void filterArgs(String[] args) {
    }

    public static void main(String[] args) {
        InsnCounter listener = new InsnCounter();
        listener.filterArgs(args);
        Config conf = JPF.createConfig(args);
        JPF jpf = new JPF(conf);
        jpf.addSearchListener(listener);
        jpf.addVMListener(listener);
        jpf.run();
    }
}

