/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.ListenerAdapter;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.ArrayStoreInstruction;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.InvokeInstruction;
import gov.nasa.jpf.search.Search;
import gov.nasa.jpf.util.DynamicObjectArray;
import java.util.logging.Logger;

public class IdleFilter
extends ListenerAdapter {
    static Logger log = JPF.getLogger("gov.nasa.jpf.tools.IdleFilter");
    DynamicObjectArray<ThreadStat> threadStats = new DynamicObjectArray(4, 16);
    ThreadStat ts;
    int maxBackJumps;
    boolean jumpPast;

    public IdleFilter(Config config) {
        this.maxBackJumps = config.getInt("idle.max_backjumps", 500);
        this.jumpPast = config.getBoolean("idle.jump", false);
    }

    @Override
    public void stateAdvanced(Search search) {
        this.ts.backJumps = 0;
        this.ts.isCleared = false;
        this.ts.loopStackDepth = 0;
        this.ts.loopEndPc = 0;
        this.ts.loopStartPc = 0;
    }

    @Override
    public void stateBacktracked(Search search) {
        this.ts.backJumps = 0;
        this.ts.isCleared = false;
        this.ts.loopStackDepth = 0;
        this.ts.loopEndPc = 0;
        this.ts.loopStartPc = 0;
    }

    @Override
    public void instructionExecuted(JVM jvm) {
        Instruction insn = jvm.getLastInstruction();
        ThreadInfo ti = jvm.getLastThreadInfo();
        int tid = ti.getIndex();
        this.ts = this.threadStats.get(tid);
        if (this.ts == null) {
            this.ts = new ThreadStat(ti.getName());
            this.threadStats.set(tid, this.ts);
        }
        if (insn.isBackJump()) {
            ++this.ts.backJumps;
            int loopStackDepth = ti.countStackFrames();
            int loopPc = jvm.getNextInstruction().getPosition();
            if (loopStackDepth != this.ts.loopStackDepth || loopPc != this.ts.loopStartPc) {
                this.ts.isCleared = false;
                this.ts.loopStackDepth = loopStackDepth;
                this.ts.loopStartPc = loopPc;
                this.ts.loopEndPc = insn.getPosition();
                this.ts.backJumps = 0;
            } else if (!this.ts.isCleared && this.ts.backJumps > this.maxBackJumps) {
                ti.reschedule(false);
                MethodInfo mi = insn.getMethodInfo();
                ClassInfo ci = mi.getClassInfo();
                int line = mi.getLineNumber(insn);
                String file = ci.getSourceFileName();
                if (this.jumpPast) {
                    Instruction next = insn.getNext();
                    ti.setPC(next);
                    log.warning("IdleFilter jumped past loop in: " + ti.getName() + "\n\tat " + ci.getName() + "." + mi.getName() + "(" + file + ":" + line + ")");
                } else {
                    jvm.ignoreState();
                    log.warning("IdleFilter pruned thread: " + ti.getName() + "\n\tat " + ci.getName() + "." + mi.getName() + "(" + file + ":" + line + ")");
                }
            }
        } else if (!this.ts.isCleared && (insn instanceof InvokeInstruction || insn instanceof ArrayStoreInstruction)) {
            int stackDepth = ti.countStackFrames();
            int pc = insn.getPosition();
            if (stackDepth == this.ts.loopStackDepth && pc >= this.ts.loopStartPc && pc < this.ts.loopEndPc) {
                this.ts.isCleared = true;
            }
        }
    }

    static class ThreadStat {
        String tname;
        int backJumps;
        boolean isCleared = false;
        int loopStartPc;
        int loopEndPc;
        int loopStackDepth;

        ThreadStat(String tname) {
            this.tname = tname;
        }
    }
}

