/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.jvm.MJIEnv;
import gov.nasa.jpf.jvm.Types;
import java.io.PrintWriter;
import java.lang.reflect.Method;

public class GenPeerDispatcher {
    static final String SYS_PKG = "gov.nasa.jpf.jvm";
    static final String INDENT = "  ";
    static final String EXECUTE = "Instruction executeMethod (ThreadInfo ti, MethodInfo mi)";
    static final String IS_COND_DETERMINISTIC = "boolean isMethodCondDeterministic (ThreadInfo ti, MethodInfo mi)";
    static final String IS_COND_EXECUTABLE = "boolean isMethodCondExecutable (ThreadInfo ti, MethodInfo mi)";
    static final String EXEC_COND = "$isExecutable_";
    static final String DETERM_COND = "$isDeterministic_";
    static final int MJI_MODS = 9;
    static String clsName;
    static PrintWriter pw;
    static Method[] tmethods;

    public static void main(String[] args) {
        if (args.length == 0 || !GenPeerDispatcher.readOptions(args)) {
            GenPeerDispatcher.showUsage();
            return;
        }
        pw = new PrintWriter(System.out, true);
        Class<?> cls = GenPeerDispatcher.getClass(clsName);
        if (cls != null) {
            GenPeerDispatcher.printNativePeerDispatcher(cls);
        }
    }

    static Class<?> getClass(String cname) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(cname);
        }
        catch (ClassNotFoundException cnfx) {
            System.err.println("target class not found: " + cname);
        }
        catch (Throwable x) {
            x.printStackTrace();
        }
        return clazz;
    }

    static boolean isMJIDetermCondCandidate(Method m) {
        if ((m.getModifiers() & 9) == 9) {
            String name = m.getName();
            return name.startsWith(DETERM_COND);
        }
        return false;
    }

    static boolean isMJIExecCondCandidate(Method m) {
        if ((m.getModifiers() & 9) == 9) {
            String name = m.getName();
            return name.startsWith(EXEC_COND);
        }
        return false;
    }

    static boolean isMJIExecuteCandidate(Method m) {
        if ((m.getModifiers() & 9) == 9) {
            String name = m.getName();
            Class<?>[] at = m.getParameterTypes();
            if (at.length >= 2 && at[0] == MJIEnv.class && at[1] == Integer.TYPE) {
                return !name.startsWith(EXEC_COND) && !name.startsWith(DETERM_COND);
            }
        }
        return false;
    }

    static String getSignature(Method m) {
        String mname = m.getName();
        if (mname.equals("$clinit") || mname.equals("$init")) {
            return "()";
        }
        Method tm = GenPeerDispatcher.getTargetMethod(m);
        if (tm != null) {
            Class<?>[] argTypes = tm.getParameterTypes();
            StringBuilder sb = new StringBuilder();
            sb.append('(');
            for (int i = 0; i < argTypes.length; ++i) {
                Class<?> t = argTypes[i];
                while (t.isArray()) {
                    sb.append('[');
                    t = t.getComponentType();
                }
                if (t == Boolean.TYPE) {
                    sb.append('Z');
                    continue;
                }
                if (t == Byte.TYPE) {
                    sb.append('B');
                    continue;
                }
                if (t == Character.TYPE) {
                    sb.append('C');
                    continue;
                }
                if (t == Short.TYPE) {
                    sb.append('S');
                    continue;
                }
                if (t == Integer.TYPE) {
                    sb.append('I');
                    continue;
                }
                if (t == Long.TYPE) {
                    sb.append('J');
                    continue;
                }
                if (t == Float.TYPE) {
                    sb.append('F');
                    continue;
                }
                if (t == Double.TYPE) {
                    sb.append('D');
                    continue;
                }
                sb.append('L');
                sb.append(t.getName().replace('.', '/'));
                sb.append(';');
            }
            sb.append(')');
            return sb.toString();
        }
        return "()";
    }

    static Method getTargetMethod(Method m) {
        String mname = m.getName();
        if (tmethods == null) {
            String tcn = m.getDeclaringClass().getName();
            tcn = tcn.substring(tcn.indexOf("JPF") + 4);
            tcn = tcn.replace('_', '.');
            try {
                Class<?> tcls = Class.forName(tcn);
                tmethods = tcls.getDeclaredMethods();
            }
            catch (ClassNotFoundException cnfx) {
                System.err.println("!! cannot find target class " + tcn + " to determine signature of: " + mname);
                return null;
            }
        }
        for (int i = 0; i < tmethods.length; ++i) {
            if (!tmethods[i].getName().equals(mname)) continue;
            return tmethods[i];
        }
        System.err.println("!! cannot find target method to determine signature of: " + mname);
        return null;
    }

    static int calcStackSize(Class[] argTypes) {
        int n = 0;
        for (int i = 2; i < argTypes.length; ++i) {
            if (argTypes[i] == Long.TYPE || argTypes[i] == Double.TYPE) {
                n += 2;
                continue;
            }
            ++n;
        }
        return n;
    }

    static void iprint(int level, String s) {
        GenPeerDispatcher.printIndent(level);
        pw.print(s);
    }

    static void iprintln(int level, String s) {
        GenPeerDispatcher.printIndent(level);
        pw.println(s);
    }

    static void printCall(Class<?> cls, Method m) {
        Class[] argTypes = m.getParameterTypes();
        int stackOffset = GenPeerDispatcher.calcStackSize(argTypes);
        pw.print(cls.getName());
        pw.print('.');
        pw.print(m.getName());
        pw.print("( env, rThis");
        if (argTypes.length > 2) {
            pw.println(',');
        }
        int i = 2;
        while (i < argTypes.length) {
            --stackOffset;
            if (argTypes[i] == Boolean.TYPE) {
                GenPeerDispatcher.iprint(7, "Types.intToBoolean( ti.peek(" + stackOffset + "))");
            } else if (argTypes[i] == Byte.TYPE) {
                GenPeerDispatcher.iprint(7, "(byte) ti.peek(" + stackOffset + ")");
            } else if (argTypes[i] == Character.TYPE) {
                GenPeerDispatcher.iprint(7, "(char) ti.peek(" + stackOffset + ")");
            } else if (argTypes[i] == Short.TYPE) {
                GenPeerDispatcher.iprint(7, "(short) ti.peek(" + stackOffset + ")");
            } else if (argTypes[i] == Integer.TYPE) {
                GenPeerDispatcher.iprint(7, "ti.peek(" + stackOffset + ")");
            } else if (argTypes[i] == Long.TYPE) {
                GenPeerDispatcher.iprint(7, "ti.longPeek(" + --stackOffset + ")");
            } else if (argTypes[i] == Float.TYPE) {
                GenPeerDispatcher.iprint(7, "Types.intToFloat( ti.peek(" + stackOffset + "))");
            } else if (argTypes[i] == Double.TYPE) {
                GenPeerDispatcher.iprint(7, "Types.longToDouble( ti.longPeek(" + --stackOffset + "))");
            } else {
                GenPeerDispatcher.iprint(7, "ti.peek(" + stackOffset + ")");
            }
            if (++i >= argTypes.length) continue;
            pw.println(',');
        }
        pw.print(")");
    }

    static void printCaseConst(Method m) {
        String mname = m.getName();
        String jniname = Types.getJNIMethodName(mname);
        String id = jniname;
        if (id.equals("$clinit")) {
            id = "<clinit>";
        } else if (id.equals("$init")) {
            id = "<init>";
        }
        String argSig = Types.getJNISignature(mname);
        id = argSig != null ? id + argSig : id + GenPeerDispatcher.getSignature(m);
        GenPeerDispatcher.iprint(3, "case ");
        pw.print(id.hashCode());
        pw.print(": // ");
        pw.println(id);
    }

    static int printExecCallProlog(Method m) {
        Class<?> retType = m.getReturnType();
        if (retType == Void.TYPE) {
            GenPeerDispatcher.iprintln(4, "retSize = 0;");
            GenPeerDispatcher.iprint(4, "");
        } else {
            if (retType == Boolean.TYPE) {
                GenPeerDispatcher.iprintln(4, "retSize = 1;");
                GenPeerDispatcher.iprint(4, "iret = Types.booleanToInt( ");
                return 1;
            }
            if (retType == Byte.TYPE) {
                GenPeerDispatcher.iprintln(4, "retSize = 1;");
                GenPeerDispatcher.iprint(4, "iret = (int) ");
            } else if (retType == Character.TYPE) {
                GenPeerDispatcher.iprintln(4, "retSize = 1;");
                GenPeerDispatcher.iprint(4, "iret = (int) ");
            } else if (retType == Short.TYPE) {
                GenPeerDispatcher.iprintln(4, "retSize = 1;");
                GenPeerDispatcher.iprint(4, "iret = (int) ");
            } else if (retType == Integer.TYPE) {
                GenPeerDispatcher.iprintln(4, "retSize = 1;");
                GenPeerDispatcher.iprint(4, "iret = ");
            } else if (retType == Long.TYPE) {
                GenPeerDispatcher.iprintln(4, "retSize = 2;");
                GenPeerDispatcher.iprint(4, "lret = ");
            } else {
                if (retType == Float.TYPE) {
                    GenPeerDispatcher.iprintln(4, "retSize = 1;");
                    GenPeerDispatcher.iprint(4, "iret = Types.floatToInt( ");
                    return 1;
                }
                if (retType == Double.TYPE) {
                    GenPeerDispatcher.iprintln(4, "retSize = 2;");
                    GenPeerDispatcher.iprint(4, "lret = Types.doubleToLong( ");
                    return 1;
                }
                GenPeerDispatcher.iprintln(4, "retSize = 1;");
                GenPeerDispatcher.iprint(4, "iret = ");
            }
        }
        return 0;
    }

    static void printExecute(Class<?> cls) {
        Method[] mths = cls.getDeclaredMethods();
        GenPeerDispatcher.iprint(1, EXECUTE);
        pw.println(" {");
        GenPeerDispatcher.iprintln(2, "int iret = 0;");
        GenPeerDispatcher.iprintln(2, "long lret = 0;");
        GenPeerDispatcher.iprintln(2, "int retSize = 0;");
        GenPeerDispatcher.iprintln(2, "String exception = null;");
        GenPeerDispatcher.iprintln(2, "int mid = mi.getUniqueName().hashCode();");
        pw.println();
        GenPeerDispatcher.iprintln(2, "MJIEnv env = ti.getMJIEnv();");
        GenPeerDispatcher.iprintln(2, "int rThis = (mi.isStatic()) ? ci.getClassObjectRef() : ti.getCalleeThis(mi);");
        pw.println();
        GenPeerDispatcher.iprintln(2, "env.setCallEnvironment( mi);");
        pw.println();
        GenPeerDispatcher.iprintln(2, "try {");
        GenPeerDispatcher.iprintln(3, "switch (mid) {");
        for (int i = 0; i < mths.length; ++i) {
            Method m = mths[i];
            if (!GenPeerDispatcher.isMJIExecuteCandidate(m)) continue;
            GenPeerDispatcher.printCaseConst(m);
            int openFuncs = GenPeerDispatcher.printExecCallProlog(m);
            GenPeerDispatcher.printCall(cls, m);
            for (int j = 0; j < openFuncs; ++j) {
                pw.print(')');
            }
            pw.println(';');
            GenPeerDispatcher.iprintln(4, "break;");
        }
        GenPeerDispatcher.iprintln(3, "default:");
        GenPeerDispatcher.iprintln(4, "return ti.createAndThrowException(  \"java.lang.UnsatisfiedLinkError\",");
        GenPeerDispatcher.iprintln(6, "\"cannot find: \" + ci.getName() + '.' + mi.getName());");
        GenPeerDispatcher.iprintln(3, "}");
        GenPeerDispatcher.iprintln(2, "} catch (Throwable x) {");
        GenPeerDispatcher.iprintln(3, "x.printStackTrace();");
        GenPeerDispatcher.iprintln(3, "return ti.createAndThrowException(  \"java.lang.reflect.InvocationTargetException\",");
        GenPeerDispatcher.iprintln(5, "ci.getName() + '.' + mi.getName());");
        GenPeerDispatcher.iprintln(2, "}");
        pw.println();
        GenPeerDispatcher.iprintln(2, "if ((exception = env.getException()) != null) {");
        GenPeerDispatcher.iprintln(3, "return ti.createAndThrowException(exception);");
        GenPeerDispatcher.iprintln(2, "}");
        pw.println();
        GenPeerDispatcher.iprintln(2, "if (env.getRepeat()) {");
        GenPeerDispatcher.iprintln(3, "return ti.getPC();");
        GenPeerDispatcher.iprintln(2, "}");
        pw.println();
        GenPeerDispatcher.iprintln(2, "ti.removeArguments(mi);");
        pw.println();
        GenPeerDispatcher.iprintln(2, "switch (retSize) {");
        GenPeerDispatcher.iprintln(2, "case 0: break; // nothing to return");
        GenPeerDispatcher.iprintln(2, "case 1: ti.push(iret, mi.isReferenceReturnType()); break;");
        GenPeerDispatcher.iprintln(2, "case 2: ti.longPush(lret); break;");
        GenPeerDispatcher.iprintln(2, "}");
        pw.println();
        GenPeerDispatcher.iprintln(2, "return ti.getPC().getNext();");
        GenPeerDispatcher.iprintln(1, "}");
    }

    static void printFooter(Class<?> cls) {
        pw.println("}");
    }

    static void printHeader(Class<?> cls) {
        pw.print("package ");
        pw.print(SYS_PKG);
        pw.println(';');
        pw.println();
        String cname = cls.getName();
        int idx = cname.lastIndexOf(46);
        if (idx > 0) {
            cname = cname.substring(idx + 1);
        }
        pw.println("import gov.nasa.jpf.JPFVMException;");
        pw.println("import gov.nasa.jpf.jvm.bytecode.Instruction;");
        pw.println();
        pw.print("class ");
        pw.print(cname);
        pw.println("$ extends NativePeer {");
    }

    static void printIndent(int level) {
        for (int i = 0; i < level; ++i) {
            pw.print(INDENT);
        }
    }

    static void printIsCond(Class<?> cls, String condPrefix) {
        Method[] mths = cls.getDeclaredMethods();
        GenPeerDispatcher.iprint(1, condPrefix);
        pw.println(" {");
        GenPeerDispatcher.iprintln(2, "boolean ret = false;");
        GenPeerDispatcher.iprintln(2, "int mid = mi.getUniqueName().hashCode();");
        pw.println();
        GenPeerDispatcher.iprintln(2, "MJIEnv env = ti.getMJIEnv();");
        GenPeerDispatcher.iprintln(2, "int rThis = (mi.isStatic()) ? ci.getClassObjectRef() : ti.getCalleeThis(mi);");
        pw.println();
        GenPeerDispatcher.iprintln(2, "env.setCallEnvironment( mi);");
        pw.println();
        GenPeerDispatcher.iprintln(2, "try {");
        GenPeerDispatcher.iprintln(3, "switch (mid) {");
        for (int i = 0; i < mths.length; ++i) {
            Method m = mths[i];
            if ((condPrefix != IS_COND_DETERMINISTIC || !GenPeerDispatcher.isMJIDetermCondCandidate(m)) && (condPrefix != IS_COND_EXECUTABLE || !GenPeerDispatcher.isMJIExecCondCandidate(m))) continue;
            GenPeerDispatcher.printCaseConst(m);
            GenPeerDispatcher.iprint(4, "ret = ");
            GenPeerDispatcher.printCall(cls, m);
            pw.println(';');
        }
        GenPeerDispatcher.iprintln(3, "default:");
        if (condPrefix == IS_COND_EXECUTABLE) {
            GenPeerDispatcher.iprintln(4, "throw new JPFVMException(\"no isExecutable() condition: \" + mi.getName());");
        } else {
            GenPeerDispatcher.iprintln(4, "throw new JPFVMException(\"no isDeterministic() condition: \" + mi.getName());");
        }
        GenPeerDispatcher.iprintln(3, "}");
        GenPeerDispatcher.iprintln(2, "} catch (Throwable x) {");
        GenPeerDispatcher.iprintln(3, "x.printStackTrace();");
        GenPeerDispatcher.iprintln(2, "}");
        pw.println();
        GenPeerDispatcher.iprintln(2, "return ret;");
        GenPeerDispatcher.iprintln(1, "}");
    }

    static void printIsCondDeterministic(Class<?> cls) {
        GenPeerDispatcher.printIsCond(cls, IS_COND_DETERMINISTIC);
    }

    static void printIsCondExecutable(Class<?> cls) {
        GenPeerDispatcher.printIsCond(cls, IS_COND_EXECUTABLE);
    }

    static void printNativePeerDispatcher(Class<?> cls) {
        GenPeerDispatcher.printHeader(cls);
        pw.println();
        GenPeerDispatcher.printExecute(cls);
        pw.println();
        GenPeerDispatcher.printIsCondDeterministic(cls);
        pw.println();
        GenPeerDispatcher.printIsCondExecutable(cls);
        pw.println();
        GenPeerDispatcher.printFooter(cls);
    }

    static boolean readOptions(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.charAt(0) == '-') {
                System.err.println("unknown option: " + arg);
                GenPeerDispatcher.showUsage();
                return false;
            }
            if (clsName != null) continue;
            clsName = arg;
        }
        return clsName != null;
    }

    static void showUsage() {
        System.out.println("usage:   'GenPeerDispatcher <className>'");
    }
}

