/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.ListenerAdapter;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.Step;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.FieldInstruction;
import gov.nasa.jpf.jvm.bytecode.InstanceFieldInstruction;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.InvokeInstruction;
import gov.nasa.jpf.jvm.bytecode.LockInstruction;
import gov.nasa.jpf.search.Search;
import gov.nasa.jpf.util.Left;
import java.io.PrintWriter;

public class ExecTracker
extends ListenerAdapter {
    boolean printInsn = true;
    boolean printSrc = false;
    boolean printMth = false;
    boolean skipInit = false;
    PrintWriter out;
    Step lastStep;
    MethodInfo lastMi;
    String linePrefix;
    boolean skip;

    public ExecTracker(Config config) {
        this.printInsn = config.getBoolean("et.print_insn", true);
        this.printSrc = config.getBoolean("et.print_src", true);
        this.printMth = config.getBoolean("et.print_mth", false);
        this.skipInit = config.getBoolean("et.skip_init", false);
        if (this.skipInit) {
            this.skip = true;
        }
        this.out = new PrintWriter(System.out, true);
    }

    @Override
    public void stateRestored(Search search) {
        int id = search.getStateNumber();
        this.out.println("----------------------------------- [" + search.getDepth() + "] restored: " + id);
    }

    @Override
    public void searchStarted(Search search) {
        this.out.println("----------------------------------- search started");
        if (this.skipInit) {
            this.out.println("      [skipping first transition]");
        }
    }

    @Override
    public void stateAdvanced(Search search) {
        int id = search.getStateNumber();
        this.out.print("----------------------------------- [" + search.getDepth() + "] forward: " + id);
        if (search.isNewState()) {
            this.out.print(" new");
        } else {
            this.out.print(" visited");
        }
        if (search.isEndState()) {
            this.out.print(" end");
        }
        this.out.println();
        this.lastStep = null;
        this.lastMi = null;
        this.linePrefix = null;
        if (this.skipInit) {
            this.skip = false;
        }
    }

    @Override
    public void stateProcessed(Search search) {
        int id = search.getStateNumber();
        this.out.println("----------------------------------- [" + search.getDepth() + "] done: " + id);
    }

    @Override
    public void stateBacktracked(Search search) {
        int id = search.getStateNumber();
        this.lastStep = null;
        this.lastMi = null;
        this.out.println("----------------------------------- [" + search.getDepth() + "] backtrack: " + id);
    }

    @Override
    public void searchFinished(Search search) {
        this.out.println("----------------------------------- search finished");
    }

    @Override
    public void gcEnd(JVM vm) {
        this.out.println("\t\t # garbage collection");
    }

    @Override
    public void instructionExecuted(JVM jvm) {
        if (this.skip) {
            return;
        }
        ThreadInfo ti = jvm.getLastThreadInfo();
        int nNoSrc = 0;
        if (this.linePrefix == null) {
            this.linePrefix = Integer.toString(ti.getIndex()) + " : ";
        }
        if (this.printSrc) {
            Step s = jvm.getLastStep();
            if (s != null && !s.equals(this.lastStep)) {
                String line = s.getLineString();
                if (line != null) {
                    if (nNoSrc > 0) {
                        this.out.println("      [" + nNoSrc + " insn w/o sources]");
                    }
                    this.out.print("        ");
                    this.out.print(Left.format(s.getLocationString(), 30));
                    this.out.print(" : ");
                    this.out.println(line.trim());
                    nNoSrc = 0;
                } else {
                    ++nNoSrc;
                }
            }
            this.lastStep = s;
        }
        if (this.printInsn) {
            MethodInfo mi;
            Instruction insn = jvm.getLastInstruction();
            if (this.printMth && (mi = insn.getMethodInfo()) != this.lastMi) {
                ClassInfo mci = mi.getClassInfo();
                this.out.print("      ");
                if (mci != null) {
                    this.out.print(mci.getName());
                    this.out.print(".");
                }
                this.out.println(mi.getUniqueName());
                this.lastMi = mi;
            }
            this.out.print(this.linePrefix);
            this.out.print('[');
            this.out.print(insn.getOffset());
            this.out.print("] ");
            this.out.print(insn);
            if (insn instanceof InvokeInstruction) {
                MethodInfo callee = ((InvokeInstruction)insn).getInvokedMethod();
                if (callee != null && callee.isMJI()) {
                    this.out.print(" [native]");
                }
            } else if (insn instanceof FieldInstruction) {
                this.out.print(" ");
                if (insn instanceof InstanceFieldInstruction) {
                    InstanceFieldInstruction iinsn = (InstanceFieldInstruction)insn;
                    this.out.print(iinsn.getId(iinsn.getLastElementInfo()));
                } else {
                    this.out.print(((FieldInstruction)insn).getVariableId());
                }
            } else if (insn instanceof LockInstruction) {
                this.out.print(" ");
                this.out.print(((LockInstruction)insn).getLastLockElementInfo());
            }
            this.out.println();
        }
    }

    @Override
    public void threadStarted(JVM jvm) {
        ThreadInfo ti = jvm.getLastThreadInfo();
        this.out.println("\t\t # thread started: " + ti.getName() + " index: " + ti.getIndex());
    }

    @Override
    public void threadTerminated(JVM jvm) {
        ThreadInfo ti = jvm.getLastThreadInfo();
        this.out.println("\t\t # thread terminated: " + ti.getName() + " index: " + ti.getIndex());
    }

    public void notifyExceptionThrown(JVM jvm) {
        ElementInfo ei = jvm.getLastElementInfo();
        MethodInfo mi = jvm.getLastThreadInfo().getMethod();
        this.out.println("\t\t\t\t # exception: " + ei + " in " + mi);
    }

    @Override
    public void choiceGeneratorAdvanced(JVM jvm) {
        this.out.println("\t\t # choice: " + jvm.getLastChoiceGenerator());
    }

    void filterArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null || !args[i].equals("-print-lines")) continue;
            this.printSrc = true;
            args[i] = null;
        }
    }

    public static void main(String[] args) {
        Config conf = JPF.createConfig(args);
        ExecTracker listener = new ExecTracker(conf);
        listener.filterArgs(args);
        JPF jpf = new JPF(conf);
        jpf.addSearchListener(listener);
        jpf.addVMListener(listener);
        jpf.run();
    }
}

