/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.ListenerAdapter;
import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.report.ConsolePublisher;
import gov.nasa.jpf.report.Publisher;
import gov.nasa.jpf.report.PublisherExtension;
import gov.nasa.jpf.search.Search;
import java.io.FileNotFoundException;
import java.io.PrintWriter;

public class ChoiceTracker
extends ListenerAdapter
implements PublisherExtension {
    Config config;
    JVM vm;
    Search search;
    protected PrintWriter pw;
    Class<?>[] cgClasses;
    boolean isReportExtension;
    String[] excludes;

    public ChoiceTracker(JPF jpf, String traceFileName, Class<?> cgClass) {
        this.config = jpf.getConfig();
        this.vm = jpf.getVM();
        this.search = jpf.getSearch();
        this.cgClasses = new Class[1];
        this.cgClasses[0] = cgClass;
        try {
            this.pw = new PrintWriter(traceFileName);
        }
        catch (FileNotFoundException fnfx) {
            System.err.println("cannot write choice trace to file: " + traceFileName);
            this.pw = new PrintWriter(System.out);
        }
    }

    public ChoiceTracker(Config config, JPF jpf) {
        this.config = config;
        this.vm = jpf.getVM();
        this.search = jpf.getSearch();
        String fname = config.getString("choice.trace");
        if (fname == null) {
            this.isReportExtension = true;
            jpf.addPublisherExtension(ConsolePublisher.class, this);
        } else {
            try {
                this.pw = new PrintWriter(fname);
            }
            catch (FileNotFoundException fnfx) {
                System.err.println("cannot write choice trace to file: " + fname);
                this.pw = new PrintWriter(System.out);
            }
        }
        this.excludes = config.getStringArray("choice.exclude");
        try {
            this.cgClasses = config.getClasses("choice.class");
        }
        catch (Config.Exception ex) {
            System.err.println("cannot create ChoiceTracker CG classes: " + this.cgClasses);
        }
    }

    public void setExcludes(String ... ex) {
        this.excludes = ex;
    }

    boolean isRelevantCG(ChoiceGenerator cg) {
        if (this.cgClasses == null) {
            return true;
        }
        for (Class<?> cls : this.cgClasses) {
            if (!cls.isAssignableFrom(cg.getClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void propertyViolated(Search search) {
        if (!this.isReportExtension) {
            this.pw.print("// application: ");
            for (String s : this.config.getArgs()) {
                this.pw.print(s);
                this.pw.print(' ');
            }
            this.pw.println();
            if (this.cgClasses == null) {
                this.pw.println("// trace over all CG classes");
            } else {
                this.pw.print("// trace over CG types: ");
                for (Class<?> cls : this.cgClasses) {
                    this.pw.print(cls.getName());
                    this.pw.print(' ');
                }
                this.pw.println();
            }
            this.pw.println("//------------------------- choice trace");
            this.printChoices();
            this.pw.println("//------------------------- end choice trace");
            this.pw.flush();
        }
    }

    void printChoices() {
        ChoiceGenerator<?>[] cgStack;
        SystemState ss = this.vm.getSystemState();
        block0: for (ChoiceGenerator<?> cg : cgStack = ss.getChoiceGenerators()) {
            Object o;
            if (!this.isRelevantCG(cg) || cg.isDone() || (o = cg.getNextChoice()) == null) continue;
            Object choice = cg.getNextChoice();
            if (this.excludes != null) {
                for (String e : this.excludes) {
                    if (choice.toString().startsWith(e)) continue block0;
                }
            }
            this.pw.println(choice);
        }
    }

    @Override
    public void publishPropertyViolation(Publisher publisher) {
        this.pw = publisher.getOut();
        publisher.publishTopicStart("choice trace " + publisher.getLastErrorId());
        this.printChoices();
    }
}

