/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.ListenerAdapter;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.InvokeInstruction;

public class CallMonitor
extends ListenerAdapter {
    @Override
    public void instructionExecuted(JVM vm) {
        Instruction insn = vm.getLastInstruction();
        ThreadInfo ti = vm.getLastThreadInfo();
        if (insn instanceof InvokeInstruction && insn.isCompleted(ti) && !ti.isInstructionSkipped()) {
            InvokeInstruction call = (InvokeInstruction)insn;
            MethodInfo mi = call.getInvokedMethod();
            Object[] args = call.getArgumentValues(ti);
            ClassInfo ci = mi.getClassInfo();
            StringBuilder sb = new StringBuilder();
            sb.append(ti.getIndex());
            sb.append(": ");
            int d = ti.getStackDepth();
            for (int i = 0; i < d; ++i) {
                sb.append(" ");
            }
            if (ci != null) {
                sb.append(ci.getName());
                sb.append('.');
            }
            sb.append(mi.getName());
            sb.append('(');
            int n = args.length - 1;
            for (int i = 0; i <= n; ++i) {
                if (args[i] != null) {
                    sb.append(args[i].toString());
                } else {
                    sb.append("null");
                }
                if (i >= n) continue;
                sb.append(',');
            }
            sb.append(')');
            System.out.println(sb);
        }
    }
}

