/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.PropertyListenerAdapter;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.ATHROW;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.search.Search;

public class AssertionProperty
extends PropertyListenerAdapter {
    boolean goOn;
    boolean caughtAssertion = false;
    String msg;

    public AssertionProperty(Config config) {
        this.goOn = config.getBoolean("search.multiple_errors", false);
    }

    @Override
    public boolean check(Search search, JVM vm) {
        return !this.caughtAssertion;
    }

    @Override
    public String getErrorMessage() {
        return this.msg;
    }

    @Override
    public void executeInstruction(JVM vm) {
        Instruction insn = vm.getLastInstruction();
        if (insn instanceof ATHROW) {
            ThreadInfo ti = vm.getLastThreadInfo();
            if (!ti.isFirstStepInsn()) {
                int xobjref;
                DynamicArea da = vm.getDynamicArea();
                Object ei = da.get(xobjref = ti.peek());
                ClassInfo ci = ((ElementInfo)ei).getClassInfo();
                if (ci.getName().equals("java.lang.AssertionError")) {
                    int msgref = ((ElementInfo)ei).getIntField("detailMessage");
                    Object eiMsg = da.get(msgref);
                    this.caughtAssertion = true;
                    if (eiMsg != null) {
                        this.msg = ((ElementInfo)eiMsg).asString();
                    }
                    ti.skipInstruction();
                    ti.setNextPC(insn);
                    ti.breakTransition();
                }
            } else {
                ti.pop();
                ti.skipInstruction();
                ti.setNextPC(insn.getNext());
            }
        }
    }

    @Override
    public void reset() {
        this.caughtAssertion = false;
        this.msg = null;
    }

    @Override
    public void propertyViolated(Search search) {
        if (this.caughtAssertion && this.goOn) {
            search.setIgnoredState(false);
        }
    }
}

