/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.test;

import gov.nasa.jpf.test.FieldReference;
import gov.nasa.jpf.test.Goal;
import gov.nasa.jpf.test.TestContext;
import gov.nasa.jpf.test.TestException;
import java.io.PrintWriter;
import java.lang.reflect.Method;

public class WithinGoal
extends Goal {
    Object v0;
    Object v1;
    boolean isDelta;

    public WithinGoal(Object v0, Object v1, boolean isDelta) {
        this.v0 = v0;
        this.v1 = v1;
        this.isDelta = isDelta;
    }

    void resolveFieldReferences(TestContext tctx) throws TestException {
        if (this.v0 instanceof FieldReference) {
            this.v0 = tctx.getFieldValue((FieldReference)this.v0);
            if (this.v0 == null) {
                throw new TestException("cannot resolve boundary " + this.v0);
            }
        }
        if (this.v1 instanceof FieldReference) {
            this.v1 = tctx.getFieldValue((FieldReference)this.v1);
            if (this.v1 == null) {
                throw new TestException("cannot resolve boundary " + this.v1);
            }
        }
    }

    void normalizeBoundaries() throws TestException {
        if (this.v0 instanceof Double) {
            if (!(this.v1 instanceof Double)) {
                this.v1 = new Double(((Number)this.v1).doubleValue());
            }
        } else if (this.v1 instanceof Double) {
            if (!(this.v0 instanceof Double)) {
                this.v0 = new Double(((Number)this.v0).doubleValue());
            }
        } else {
            if (!(this.v0 instanceof Integer)) {
                this.v0 = new Integer(((Number)this.v0).intValue());
            }
            if (!(this.v1 instanceof Integer)) {
                this.v1 = new Integer(((Number)this.v1).intValue());
            }
        }
        if (this.v0.getClass() != this.v1.getClass() || !(this.v0 instanceof Number)) {
            throw new TestException("incompatible boundary types: " + this.v0 + "," + this.v1);
        }
    }

    void promoteToDoubleBoundaries(TestContext tctx, Class<?> realCls) {
        this.v0 = new Double(((Number)this.v0).doubleValue());
        this.v1 = new Double(((Number)this.v1).doubleValue());
    }

    Object promoteResult(Number res) {
        if (this.v0 instanceof Double) {
            if (!(res instanceof Double)) {
                return new Double(res.doubleValue());
            }
        } else if (this.v0 instanceof Integer && !(res instanceof Integer)) {
            return new Integer(res.intValue());
        }
        return res;
    }

    @Override
    public boolean postCheck(TestContext tctx, Method m, Object res, Throwable t) throws TestException {
        if (!(res instanceof Number)) {
            throw new TestException("result type not a number: " + res);
        }
        this.resolveFieldReferences(tctx);
        this.normalizeBoundaries();
        if (res instanceof Double) {
            this.promoteToDoubleBoundaries(tctx, res.getClass());
        } else {
            res = this.promoteResult((Number)res);
        }
        if (this.v0 instanceof Double) {
            double d0 = (Double)this.v0;
            double d1 = (Double)this.v1;
            double r = (Double)res;
            if (this.isDelta) {
                return r >= d0 - d1 && r <= d0 + d1;
            }
            return r >= d0 && r <= d1;
        }
        if (this.v0 instanceof Integer) {
            double i0 = ((Integer)this.v0).intValue();
            double i1 = ((Integer)this.v1).intValue();
            double r = ((Integer)res).intValue();
            if (this.isDelta) {
                return r >= i0 - i1 && r <= i0 + i1;
            }
            return r >= i0 && r <= i1;
        }
        return false;
    }

    @Override
    public Class<?> getGoalType() {
        return Number.class;
    }

    @Override
    public void printOn(PrintWriter pw) {
        if (this.isDelta) {
            pw.print(this.v0);
            pw.print("+-");
            pw.print(this.v1);
        } else {
            pw.print(this.v0);
            pw.print(",");
            pw.print(this.v1);
        }
    }
}

