/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.test;

import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.InvokeInstruction;
import gov.nasa.jpf.jvm.bytecode.ReturnInstruction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class VarLookup {
    HashMap<Object, Object> cache;

    public abstract String getLookupType();

    public Object getValue(String key) {
        return null;
    }

    public HashMap<Object, Object> getCache() {
        return this.cache;
    }

    VarLookup() {
        this.cache = new HashMap();
    }

    VarLookup(HashMap<Object, Object> map) {
        this.cache = map;
    }

    Object getSpecialValue(String var) {
        return null;
    }

    public boolean containsKey(Object key) {
        return this.cache.containsKey(key);
    }

    public Object lookup(Object key) {
        Object v = null;
        if (this.cache.containsKey(key)) {
            v = this.cache.get(key);
        } else if (key instanceof String) {
            String var = (String)key;
            v = this.getSpecialValue(var);
            if (v == null) {
                v = this.getValue(var);
            }
            this.cache.put(key, v);
        }
        return v;
    }

    public void put(Object key, Object value) {
        this.cache.put(key, value);
    }

    public void purgeVars() {
        Iterator<Map.Entry<Object, Object>> it = this.cache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> e = it.next();
            Object key = e.getKey();
            if (!(key instanceof String) || "Result".equals(key)) continue;
            it.remove();
        }
    }

    public static class Invariant
    extends VarLookup {
        ThreadInfo ti;

        public Invariant(ThreadInfo ti) {
            this.ti = ti;
        }

        @Override
        public Object getValue(String varName) {
            return this.ti.getTopFrame().getFieldValue(varName);
        }

        @Override
        public String getLookupType() {
            return "invariant";
        }
    }

    public static class PostCond
    extends VarLookup {
        ThreadInfo ti;
        ReturnInstruction ret;

        public PostCond(ThreadInfo ti, ReturnInstruction ret, VarLookup old) {
            super(old.cache);
            this.ti = ti;
            this.ret = ret;
        }

        @Override
        public Object getValue(String varName) {
            if (varName.equals("Result")) {
                return this.ret.getReturnValue(this.ti);
            }
            return this.ti.getTopFrame().getLocalOrFieldValue(varName);
        }

        @Override
        public String getLookupType() {
            return "postcondition";
        }
    }

    public static class PostCondPreExec
    extends VarLookup {
        ThreadInfo ti;

        public PostCondPreExec(ThreadInfo ti) {
            this.ti = ti;
        }

        @Override
        public Object getValue(String varName) {
            Object v = this.cache.get(varName);
            if (v == null) {
                v = this.ti.getTopFrame().getLocalOrFieldValue(varName);
                this.cache.put(varName, v);
            }
            return v;
        }

        @Override
        public String getLookupType() {
            return "postcondition (pre-execution)";
        }
    }

    public static class PreCond
    extends VarLookup {
        ThreadInfo ti;
        InvokeInstruction call;

        public PreCond(ThreadInfo ti, InvokeInstruction call) {
            this.ti = ti;
            this.call = call;
        }

        @Override
        public Object getValue(String varName) {
            return this.call.getFieldOrArgumentValue(varName, this.ti);
        }

        @Override
        public String getLookupType() {
            return "precondition";
        }
    }
}

