/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.test;

import gov.nasa.jpf.test.ArgList;
import gov.nasa.jpf.test.Goal;
import gov.nasa.jpf.test.ValSet;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class TestSpec {
    ArrayList<ArgList> targetArgs = new ArrayList();
    ArrayList<ArgList> callArgs = new ArrayList();
    ArrayList<Goal> goals = new ArrayList();

    public void addTargetArgs(ArgList alist) {
        this.targetArgs.add(alist);
    }

    public void addCallArgs(ArgList alist) {
        this.callArgs.add(alist);
    }

    public List<ArgList> getTargetArgs() {
        return this.targetArgs;
    }

    public List<ArgList> getCallArgs() {
        return this.callArgs;
    }

    public List<Object[]> getCallArgCombinations() {
        ArrayList<Object[]> ac = new ArrayList<Object[]>();
        for (ArgList al : this.callArgs) {
            ac.addAll(al.getArgCombinations());
        }
        return ac;
    }

    public void addGoal(Goal g) {
        this.goals.add(g);
    }

    public List<Goal> getGoals() {
        return this.goals;
    }

    public void printOn(PrintWriter pw) {
        pw.println("TestSpec {");
        if (!this.targetArgs.isEmpty()) {
            for (ArgList al : this.targetArgs) {
                pw.println("  targetArgs={");
                for (ValSet vs : al) {
                    pw.print("    ");
                    vs.printOn(pw);
                    pw.println();
                }
                pw.println("  }");
            }
        }
        if (!this.callArgs.isEmpty()) {
            for (ArgList al : this.callArgs) {
                pw.println("  callArgs={");
                for (ValSet vs : al) {
                    pw.print("    ");
                    vs.printOn(pw);
                    pw.println();
                }
                pw.println("  }");
            }
        }
        if (!this.goals.isEmpty()) {
            for (Goal g : this.goals) {
                pw.print("  goal=");
                g.printOn(pw);
                pw.println();
            }
        }
        pw.println("}");
    }
}

