/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.test;

import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.test.ContractException;
import gov.nasa.jpf.test.VarLookup;

public abstract class Operand {
    public static final Const NULL = new Const(null);
    public static final Const EPS = new Const(1.0E-6);
    public static final String RESULT = "Result";

    public abstract Object getValue(VarLookup var1);

    public void saveOldOperandValue(VarLookup lookup) {
    }

    public Number getNumberValue(VarLookup lookup) {
        Object v = this.getValue(lookup);
        if (v != null && v instanceof Number) {
            return (Number)v;
        }
        throw new ContractException("number expected: " + this);
    }

    public boolean isReferenceValue(VarLookup lookup) {
        Object v = this.getValue(lookup);
        return v != null && v instanceof ElementInfo;
    }

    public static class Result
    extends Operand {
        @Override
        public Object getValue(VarLookup lookup) {
            return lookup.getValue(Operand.RESULT);
        }

        public String toString() {
            return Operand.RESULT;
        }
    }

    public static class Const
    extends Operand {
        Object value;

        public Const(Object val) {
            this.value = val;
        }

        @Override
        public Object getValue(VarLookup vl) {
            return this.value;
        }

        public String toString() {
            if (this.value == null) {
                return "null";
            }
            return this.value.toString();
        }
    }

    public static class ClassRef
    extends Operand {
        String clsName;

        public ClassRef(String clsName) {
            this.clsName = clsName;
        }

        @Override
        public Object getValue(VarLookup vl) {
            return ClassInfo.getClassInfo(this.clsName);
        }

        public String toString() {
            return "class " + this.clsName;
        }
    }

    public static class VarRef
    extends Operand {
        String id;

        public VarRef(String id) {
            this.id = id;
        }

        @Override
        public Object getValue(VarLookup vl) {
            return vl.lookup(this.id);
        }

        public String toString() {
            return this.id;
        }
    }
}

