/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.test;

import gov.nasa.jpf.test.ArgList;
import gov.nasa.jpf.test.Goal;
import gov.nasa.jpf.test.TestContext;
import gov.nasa.jpf.test.TestException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.List;

public class MemoryGoal
extends Goal {
    TestContext tctx;
    long maxGrowth;
    long freeMem1;
    long freeMem2;

    public MemoryGoal(TestContext tctx, ArgList args) throws TestException {
        this.tctx = tctx;
        if (args != null) {
            List<Object[]> al = args.getArgCombinations();
            if (al.size() != 1 || al.get(0).length != 1 || !(al.get(0)[0] instanceof Number)) {
                throw new TestException("MemoryGoal only accepts one number parameter");
            }
            this.maxGrowth = ((Number)al.get(0)[0]).longValue();
        } else {
            this.maxGrowth = 0L;
        }
    }

    public MemoryGoal(long maxGrowth) {
        this.maxGrowth = maxGrowth;
    }

    @Override
    public boolean preCheck(TestContext tctx, Method m) {
        Runtime rt = Runtime.getRuntime();
        rt.gc();
        this.freeMem1 = rt.freeMemory();
        return true;
    }

    @Override
    public boolean postCheck(TestContext tctx, Method m, Object res, Throwable t) {
        Runtime rt = Runtime.getRuntime();
        rt.gc();
        this.freeMem2 = rt.freeMemory();
        long diff = this.freeMem1 - this.freeMem2;
        tctx.log("memory growth: " + diff + " bytes");
        return diff <= this.maxGrowth;
    }

    @Override
    public void printOn(PrintWriter pw) {
        pw.print("alloc limit <= ");
        pw.print(this.maxGrowth);
    }
}

