/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.test;

import gov.nasa.jpf.JPF;
import gov.nasa.jpf.test.ContractException;
import gov.nasa.jpf.test.Operand;
import gov.nasa.jpf.test.VarLookup;
import java.util.logging.Logger;

public abstract class Contract {
    protected static Logger log = JPF.getLogger("gov.nasa.jpf.test");
    Contract superContract;
    static double EPS = 1.0E-10;

    public abstract boolean holds(VarLookup var1);

    protected abstract void saveOldOperandValues(VarLookup var1);

    public void saveOldValues(VarLookup lookup) {
        Contract c = this;
        while (c != null) {
            if (!c.isEmpty()) {
                this.saveOldOperandValues(lookup);
            }
            c = c.superContract;
        }
    }

    public boolean holdsAny(VarLookup lookup) {
        Contract c = this;
        while (c != null) {
            if (!c.isEmpty() && c.holds(lookup)) {
                return true;
            }
            c = c.superContract;
        }
        return false;
    }

    public boolean holdsAll(VarLookup lookup) {
        Contract c = this;
        while (c != null) {
            if (!c.isEmpty() && !c.holds(lookup)) {
                return false;
            }
            c = c.superContract;
        }
        return true;
    }

    public void setSuperContract(Contract c) {
        this.superContract = c;
    }

    public Contract getSuperContract() {
        return this.superContract;
    }

    public boolean isEmpty() {
        return false;
    }

    public String getErrorMessage(VarLookup lookupPolicy, String combinator) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        Contract c = this;
        while (c != null) {
            if (!c.isEmpty()) {
                if (c != this) {
                    sb.append(' ');
                    sb.append(combinator);
                    sb.append(' ');
                }
                sb.append(c.toString());
            }
            c = c.superContract;
        }
        sb.append("\"");
        return sb.toString();
    }

    public boolean hasNonEmptyContracts() {
        if (this.isEmpty()) {
            if (this.superContract != null) {
                return this.superContract.hasNonEmptyContracts();
            }
            return false;
        }
        return true;
    }

    public int compareNumericValues(Object v1, Object v2) {
        if (v1 == null || v2 == null || !(v1 instanceof Number) || !(v2 instanceof Number)) {
            throw new ContractException("numeric comparison for non numbers: " + v1 + ',' + v2);
        }
        if (v1 instanceof Double || v1 instanceof Float) {
            double r = ((Number)v1).doubleValue() - ((Number)v2).doubleValue();
            if (Math.abs(r) < EPS) {
                return 0;
            }
            if (r < 0.0) {
                return -1;
            }
            return 1;
        }
        int r = ((Number)v1).intValue() - ((Number)v2).intValue();
        if (r < 0) {
            return -1;
        }
        if (r == 0) {
            return 0;
        }
        return 1;
    }

    public static class Matches
    extends UnaryContract {
        String regex;

        public Matches(Operand o, String regex) {
            super(o);
            this.regex = regex;
        }

        @Override
        public boolean holds(VarLookup lookup) {
            Object v1 = this.o1.getValue(lookup);
            if (v1 != null) {
                return this.regex.matches(v1.toString());
            }
            return false;
        }

        public String toString() {
            return "(" + this.o1 + " matches \"" + this.regex + "\")";
        }
    }

    public static class WithinCenter
    extends TertiaryContract {
        public WithinCenter(Operand testObj, Operand center, Operand delta) {
            super(testObj, center, delta);
        }

        boolean isFP(Number n) {
            return n != null && (n instanceof Double || n instanceof Float);
        }

        @Override
        public boolean holds(VarLookup lookup) {
            int i3;
            int i2;
            Number n1 = this.o1.getNumberValue(lookup);
            Number n2 = this.o2.getNumberValue(lookup);
            Number n3 = this.o3.getNumberValue(lookup);
            if (this.isFP(n1) || this.isFP(n2) || this.isFP(3)) {
                double d3;
                double d2;
                double d1 = n1.doubleValue();
                return d1 - EPS >= (d2 = n2.doubleValue()) - (d3 = n3.doubleValue()) && d1 + EPS <= d2 + d3;
            }
            int i1 = n1.intValue();
            return i1 >= (i2 = n2.intValue()) - (i3 = n3.intValue()) && i1 <= i2 + i3;
        }

        public String toString() {
            return "(" + this.o1 + " within " + this.o2 + "+-" + this.o3 + ")";
        }
    }

    public static class Within
    extends TertiaryContract {
        public Within(Operand testObj, Operand lowerBoundary, Operand upperBoundary) {
            super(testObj, lowerBoundary, upperBoundary);
        }

        @Override
        public boolean holds(VarLookup lookup) {
            Object v1 = this.o1.getValue(lookup);
            Object v2 = this.o2.getValue(lookup);
            Object v3 = this.o3.getValue(lookup);
            return this.compareNumericValues(v1, v2) >= 0 && this.compareNumericValues(v1, v3) <= 0;
        }

        public String toString() {
            return "(" + this.o1 + " within " + this.o2 + ',' + this.o3 + ")";
        }
    }

    public static class InstanceOf
    extends UnaryContract {
        String type;

        public InstanceOf(Operand o, String type) {
            super(o);
            this.type = type;
        }

        @Override
        public boolean holds(VarLookup lookup) {
            Object v = this.o1.getValue(lookup);
            return true;
        }

        public String toString() {
            return "(" + this.o1 + " instanceOf " + this.type + ")";
        }
    }

    public static class NotEmpty
    extends UnaryContract {
        public NotEmpty(Operand o) {
            super(o);
        }

        @Override
        public boolean holds(VarLookup lookup) {
            Object v = this.o1.getValue(lookup);
            return true;
        }

        public String toString() {
            return "(" + this.o1 + " notEmpty)";
        }
    }

    public static class IsEmpty
    extends UnaryContract {
        public IsEmpty(Operand o) {
            super(o);
        }

        @Override
        public boolean holds(VarLookup lookup) {
            Object v = this.o1.getValue(lookup);
            return true;
        }

        public String toString() {
            return "(" + this.o1 + " isEmpty)";
        }
    }

    public static class GE
    extends BinaryContract {
        public GE(Operand o1, Operand o2) {
            super(o1, o2);
        }

        @Override
        public boolean holds(VarLookup lookup) {
            Object v2;
            Object v1 = this.o1.getValue(lookup);
            return this.compareNumericValues(v1, v2 = this.o2.getValue(lookup)) >= 0;
        }

        public String toString() {
            return "(" + this.o1 + " >= " + this.o2 + ")";
        }
    }

    public static class GT
    extends BinaryContract {
        public GT(Operand o1, Operand o2) {
            super(o1, o2);
        }

        @Override
        public boolean holds(VarLookup lookup) {
            Object v2;
            Object v1 = this.o1.getValue(lookup);
            return this.compareNumericValues(v1, v2 = this.o2.getValue(lookup)) > 0;
        }

        public String toString() {
            return "(" + this.o1 + " > " + this.o2 + ")";
        }
    }

    public static class LE
    extends BinaryContract {
        public LE(Operand o1, Operand o2) {
            super(o1, o2);
        }

        @Override
        public boolean holds(VarLookup lookup) {
            Object v2;
            Object v1 = this.o1.getValue(lookup);
            return this.compareNumericValues(v1, v2 = this.o2.getValue(lookup)) <= 0;
        }

        public String toString() {
            return "(" + this.o1 + " <= " + this.o2 + ")";
        }
    }

    public static class LT
    extends BinaryContract {
        public LT(Operand o1, Operand o2) {
            super(o1, o2);
        }

        @Override
        public boolean holds(VarLookup lookup) {
            Object v2;
            Object v1 = this.o1.getValue(lookup);
            return this.compareNumericValues(v1, v2 = this.o2.getValue(lookup)) < 0;
        }

        public String toString() {
            return "(" + this.o1 + " < " + this.o2 + ")";
        }
    }

    public static class NE
    extends BinaryContract {
        public NE(Operand o1, Operand o2) {
            super(o1, o2);
        }

        @Override
        public boolean holds(VarLookup lookup) {
            Object v2;
            Object v1 = this.o1.getValue(lookup);
            if (v1 == (v2 = this.o2.getValue(lookup))) {
                return false;
            }
            if (v1 == null || v2 == null) {
                return true;
            }
            return !v1.equals(v2);
        }

        public String toString() {
            return "(" + this.o1 + " != " + this.o2 + ")";
        }
    }

    public static class EQ
    extends BinaryContract {
        public EQ(Operand o1, Operand o2) {
            super(o1, o2);
        }

        @Override
        public boolean holds(VarLookup lookup) {
            Object v2;
            Object v1 = this.o1.getValue(lookup);
            if (v1 == (v2 = this.o2.getValue(lookup))) {
                return true;
            }
            if (v1 == null || v2 == null) {
                return false;
            }
            return v1.equals(v2);
        }

        public String toString() {
            return "(" + this.o1 + " == " + this.o2 + ")";
        }
    }

    static abstract class UnaryContract
    extends Contract {
        Operand o1;

        protected UnaryContract(Operand o) {
            this.o1 = o;
        }

        @Override
        protected void saveOldOperandValues(VarLookup lookup) {
            this.o1.saveOldOperandValue(lookup);
        }
    }

    static abstract class BinaryContract
    extends Contract {
        Operand o1;
        Operand o2;

        protected BinaryContract(Operand o1, Operand o2) {
            this.o1 = o1;
            this.o2 = o2;
        }

        @Override
        protected void saveOldOperandValues(VarLookup lookup) {
            this.o1.saveOldOperandValue(lookup);
            this.o2.saveOldOperandValue(lookup);
        }
    }

    static abstract class TertiaryContract
    extends Contract {
        Operand o1;
        Operand o2;
        Operand o3;

        protected TertiaryContract(Operand o1, Operand o2, Operand o3) {
            this.o1 = o1;
            this.o2 = o2;
            this.o3 = o3;
        }

        @Override
        protected void saveOldOperandValues(VarLookup lookup) {
            this.o1.saveOldOperandValue(lookup);
            this.o2.saveOldOperandValue(lookup);
            this.o3.saveOldOperandValue(lookup);
        }
    }
}

