/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.test;

import gov.nasa.jpf.test.FieldReference;
import gov.nasa.jpf.test.Goal;
import gov.nasa.jpf.test.TestContext;
import gov.nasa.jpf.test.TestException;
import gov.nasa.jpf.test.ValSet;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.List;

public class CompareGoal
extends Goal {
    Operator op;
    ValSet values;

    CompareGoal(Operator compareOp, ValSet compareVal) {
        this.op = compareOp;
        this.values = compareVal;
    }

    @Override
    public Class<?> getGoalType() {
        block3: {
            block2: {
                if (this.op == Operator.EQ) break block2;
                if (this.op != Operator.NE) break block3;
            }
            return Object.class;
        }
        return Number.class;
    }

    @Override
    public void printOn(PrintWriter pw) {
        if (this.op != null) {
            pw.print('\"');
            pw.print((Object)this.op);
            pw.print('\"');
        }
        if (this.values != null) {
            if (this.op != null) {
                pw.print(' ');
            }
            this.values.printOn(pw);
        }
    }

    void resolveFieldReferences(TestContext tctx) throws TestException {
        List<Object> v = this.values.getValues();
        int n = v.size();
        for (int i = 0; i < n; ++i) {
            Object o = v.get(i);
            if (!(o instanceof FieldReference)) continue;
            Object fv = tctx.getFieldValue((FieldReference)o);
            if (fv == null) {
                throw new TestException("cannot resolve compare value " + o);
            }
            v.set(i, fv);
        }
    }

    @Override
    public boolean postCheck(TestContext tctx, Method m, Object res, Throwable t) throws TestException {
        this.resolveFieldReferences(tctx);
        switch (this.op) {
            case EQ: {
                for (Object v : this.values) {
                    if (!v.equals(res)) continue;
                    return true;
                }
                break;
            }
            case NE: {
                for (Object v : this.values) {
                    if (!v.equals(res)) continue;
                    return false;
                }
                return true;
            }
            case LT: 
            case LE: 
            case GT: 
            case GE: {
                if (!(res instanceof Number)) {
                    throw new TestException("can't compare non-Number return type: " + res);
                }
                double r = ((Number)res).doubleValue();
                for (Object v : this.values) {
                    if (v instanceof Number) {
                        double d = ((Number)v).doubleValue();
                        if (this.compare(r, d)) continue;
                        return false;
                    }
                    throw new TestException("can't compare to non-Number type: " + v);
                }
                return true;
            }
        }
        return false;
    }

    boolean compare(double r, double d) {
        switch (this.op) {
            case LT: {
                if (r < d) break;
                return false;
            }
            case LE: {
                if (r <= d) break;
                return false;
            }
            case GT: {
                if (r > d) break;
                return false;
            }
            case GE: {
                if (r >= d) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public static enum Operator {
        EQ("=="),
        NE("!="),
        LT("<"),
        LE("<="),
        GT(">"),
        GE(">=");

        private String op;

        private Operator(String s) {
            this.op = s;
        }

        public String toString() {
            return this.op;
        }
    }
}

