/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.test;

import gov.nasa.jpf.test.ValSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ArgList
implements Iterable<ValSet> {
    ArrayList<ValSet> args = new ArrayList();

    public void add(ValSet s) {
        this.args.add(s);
    }

    @Override
    public Iterator<ValSet> iterator() {
        return this.args.iterator();
    }

    public int size() {
        return this.args.size();
    }

    void addArgCombinations(int i, Object[] combi, List<Object[]> list) {
        int n1 = this.args.size() - 1;
        Iterator<Object> i$ = this.args.get(i).iterator();
        while (i$.hasNext()) {
            Object v;
            combi[i] = v = i$.next();
            if (i == n1) {
                list.add((Object[])combi.clone());
                continue;
            }
            if (i >= n1) continue;
            this.addArgCombinations(i + 1, combi, list);
        }
    }

    public List<Object[]> getArgCombinations() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        Object[] combi = new Object[this.args.size()];
        if (this.args.isEmpty()) {
            list.add(combi);
        } else {
            this.addArgCombinations(0, combi, list);
        }
        return list;
    }

    public Class<?>[] getArgTypes() {
        int n = this.args.size();
        Class[] types = new Class[n];
        for (int i = 0; i < n; ++i) {
            types[i] = this.args.get(i).getType();
        }
        return types;
    }

    public ArgList(ValSet ... valSets) {
        for (ValSet s : valSets) {
            this.add(s);
        }
    }

    public static void main(String[] args) {
        ArgList a = new ArgList(new ValSet(42, 43), new ValSet("bla", "gna"), new ValSet(0.1));
        for (Object[] v : a.getArgCombinations()) {
            for (int i = 0; i < v.length; ++i) {
                if (i > 0) {
                    System.out.print(',');
                }
                System.out.print(v[i]);
            }
            System.out.println();
        }
    }
}

