/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.search.heuristic;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.search.heuristic.PrioritizedState;
import java.util.Iterator;
import java.util.TreeSet;

public class StaticPriorityQueue
extends TreeSet<PrioritizedState> {
    int maxQueueSize;

    public StaticPriorityQueue(Config config) {
        this.maxQueueSize = config.getInt("search.heuristic.queue_limit", 1024);
        if (this.maxQueueSize < 0) {
            this.maxQueueSize = Integer.MAX_VALUE;
        }
    }

    @Override
    public boolean add(PrioritizedState s) {
        if (this.size() < this.maxQueueSize) {
            return super.add(s);
        }
        PrioritizedState last = (PrioritizedState)this.last();
        if (s.compareTo(last) < 0) {
            this.remove(last);
            return super.add(s);
        }
        return false;
    }

    public boolean isQueueLimitReached() {
        return this.size() >= this.maxQueueSize;
    }

    void dump() {
        int i = 0;
        System.err.print('[');
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (i++ > 0) {
                System.err.print(',');
            }
            System.err.print(it.next());
        }
        System.err.println(']');
    }
}

