/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.search.heuristic;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.search.heuristic.HeuristicSearch;
import gov.nasa.jpf.search.heuristic.HeuristicState;
import gov.nasa.jpf.search.heuristic.PrioritizedState;
import gov.nasa.jpf.search.heuristic.StaticPriorityQueue;

public abstract class SimplePriorityHeuristic
extends HeuristicSearch {
    StaticPriorityQueue queue;

    public SimplePriorityHeuristic(Config config, JVM vm) throws Config.Exception {
        super(config, vm);
        this.queue = new StaticPriorityQueue(config);
    }

    protected abstract int computeHeuristicValue();

    protected int computeAstarPathCost(JVM vm) {
        return vm.getPathLength();
    }

    @Override
    protected HeuristicState queueCurrentState() {
        int heuristicValue;
        if (this.vm.isInterestingState()) {
            heuristicValue = 0;
        } else if (this.vm.isBoringState()) {
            heuristicValue = Integer.MAX_VALUE;
        } else {
            heuristicValue = this.computeHeuristicValue();
            if (this.useAstar) {
                heuristicValue += this.computeAstarPathCost(this.vm);
            }
        }
        PrioritizedState hState = new PrioritizedState(this.vm, heuristicValue);
        this.queue.add(hState);
        return hState;
    }

    @Override
    protected HeuristicState getNextQueuedState() {
        if (this.queue.size() == 0) {
            return null;
        }
        HeuristicState hState = (HeuristicState)this.queue.first();
        if (this.isBeamSearch) {
            this.queue.clear();
        } else {
            this.queue.remove(hState);
        }
        return hState;
    }

    @Override
    public int getQueueSize() {
        return this.queue.size();
    }

    @Override
    public boolean isQueueLimitReached() {
        return this.queue.isQueueLimitReached();
    }
}

