/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.search.heuristic;

import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.search.heuristic.HeuristicState;

public class PrioritizedState
extends HeuristicState
implements Comparable<PrioritizedState> {
    int heuristicValue;

    public PrioritizedState(JVM vm, int heuristicValue) {
        super(vm);
        this.heuristicValue = heuristicValue;
    }

    public int getPriority() {
        return this.heuristicValue;
    }

    @Override
    public int compareTo(PrioritizedState o) {
        int diff = this.heuristicValue - o.heuristicValue;
        if (diff == 0) {
            return this.stateId - o.stateId;
        }
        return diff;
    }

    public boolean equals(Object o) {
        if (o instanceof PrioritizedState) {
            PrioritizedState other = (PrioritizedState)o;
            return this.stateId == other.stateId && this.heuristicValue == other.heuristicValue;
        }
        return false;
    }

    public String toString() {
        return "{" + this.stateId + ',' + this.heuristicValue + '}';
    }
}

