/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.search.heuristic;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.Path;
import gov.nasa.jpf.search.heuristic.SimplePriorityHeuristic;

public class Interleaving
extends SimplePriorityHeuristic {
    int historyLimit;

    public Interleaving(Config config, JVM vm) throws Config.Exception {
        super(config, vm);
        this.historyLimit = config.getInt("search.heuristic.thread_history_limit", -1);
    }

    @Override
    protected int computeHeuristicValue() {
        int aliveThreads = this.vm.getAliveThreadCount();
        Path path = this.vm.getPath();
        int pathSize = path.size();
        int lastThread = this.vm.getLastTransition().getThreadIndex();
        int h_value = 0;
        if (aliveThreads > 1) {
            for (int i = Math.max(0, pathSize - this.historyLimit); i < pathSize; ++i) {
                if (path.get(i).getThreadIndex() != lastThread) continue;
                h_value += (pathSize - i) * aliveThreads;
            }
        }
        return h_value;
    }
}

