/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.search.heuristic;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.search.heuristic.SimplePriorityHeuristic;

public class GlobalSwitchThread
extends SimplePriorityHeuristic {
    private int[] threads;

    public GlobalSwitchThread(Config config, JVM vm) throws Config.Exception {
        super(config, vm);
        int threadHistorySize = config.getInt("search.heuristic.thread_history_size", 10);
        this.threads = new int[threadHistorySize];
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i] = -1;
        }
    }

    @Override
    protected int computeHeuristicValue() {
        int aliveThreads = this.vm.getAliveThreadCount();
        int lastRun = this.vm.getLastTransition().getThreadIndex();
        int h_value = 0;
        if (aliveThreads > 1) {
            for (int i = 0; i < this.threads.length; ++i) {
                if (lastRun != this.threads[i]) continue;
                h_value += (this.threads.length - i) * aliveThreads;
            }
        }
        int temp0 = this.threads[0];
        this.threads[0] = lastRun;
        for (int i = 1; i < this.threads.length; ++i) {
            int temp1 = this.threads[i];
            this.threads[i] = temp0;
            temp0 = temp1;
        }
        return h_value;
    }
}

