/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.search;

import gov.nasa.jpf.search.Search;
import gov.nasa.jpf.search.SearchListener;

public class SearchListenerMulticaster
implements SearchListener {
    SearchListener head;
    SearchListener tail;

    public static SearchListener add(SearchListener oldListener, SearchListener newListener) {
        if (newListener == null) {
            return oldListener;
        }
        if (oldListener == null) {
            return newListener;
        }
        if (newListener == oldListener) {
            return oldListener;
        }
        if (oldListener instanceof SearchListenerMulticaster) {
            SearchListenerMulticaster c = (SearchListenerMulticaster)oldListener;
            while (c != null) {
                if (c.tail == newListener) {
                    return oldListener;
                }
                if (c.head == newListener) {
                    return oldListener;
                }
                if (!(c.head instanceof SearchListenerMulticaster)) break;
                c = (SearchListenerMulticaster)c.head;
            }
        }
        return new SearchListenerMulticaster(oldListener, newListener);
    }

    public static boolean containsType(SearchListener listener, Class<?> type) {
        if (listener == null) {
            return false;
        }
        if (listener instanceof SearchListenerMulticaster) {
            SearchListenerMulticaster l = (SearchListenerMulticaster)listener;
            while (l != null) {
                if (type.isAssignableFrom(l.tail.getClass())) {
                    return true;
                }
                if (l.head instanceof SearchListenerMulticaster) {
                    l = (SearchListenerMulticaster)l.head;
                    continue;
                }
                return type.isAssignableFrom(l.head.getClass());
            }
            return false;
        }
        return type.isAssignableFrom(listener.getClass());
    }

    public static SearchListener remove(SearchListener oldListener, SearchListener removeListener) {
        if (oldListener == removeListener) {
            return null;
        }
        if (oldListener instanceof SearchListenerMulticaster) {
            return ((SearchListenerMulticaster)oldListener).remove(removeListener);
        }
        return oldListener;
    }

    protected SearchListener remove(SearchListener listener) {
        if (listener == this.head) {
            return this.tail;
        }
        if (listener == this.tail) {
            return this.head;
        }
        if (this.head instanceof SearchListenerMulticaster) {
            SearchListenerMulticaster h = (SearchListenerMulticaster)this.head;
            if (this.tail instanceof SearchListenerMulticaster) {
                SearchListenerMulticaster t = (SearchListenerMulticaster)this.tail;
                return new SearchListenerMulticaster(h.remove(listener), t.remove(listener));
            }
            return new SearchListenerMulticaster(h.remove(listener), this.tail);
        }
        if (this.tail instanceof SearchListenerMulticaster) {
            SearchListenerMulticaster t = (SearchListenerMulticaster)this.tail;
            return new SearchListenerMulticaster(this.head, t.remove(listener));
        }
        return this;
    }

    public SearchListenerMulticaster(SearchListener h, SearchListener t) {
        this.head = h;
        this.tail = t;
    }

    @Override
    public void stateAdvanced(Search search) {
        this.head.stateAdvanced(search);
        this.tail.stateAdvanced(search);
    }

    @Override
    public void stateProcessed(Search search) {
        this.head.stateProcessed(search);
        this.tail.stateProcessed(search);
    }

    @Override
    public void stateBacktracked(Search search) {
        this.head.stateBacktracked(search);
        this.tail.stateBacktracked(search);
    }

    @Override
    public void stateStored(Search search) {
        this.head.stateStored(search);
        this.tail.stateStored(search);
    }

    @Override
    public void stateRestored(Search search) {
        this.head.stateRestored(search);
        this.tail.stateRestored(search);
    }

    @Override
    public void propertyViolated(Search search) {
        this.head.propertyViolated(search);
        this.tail.propertyViolated(search);
    }

    @Override
    public void searchStarted(Search search) {
        this.head.searchStarted(search);
        this.tail.searchStarted(search);
    }

    @Override
    public void searchFinished(Search search) {
        this.tail.searchFinished(search);
        this.head.searchFinished(search);
    }

    @Override
    public void searchConstraintHit(Search search) {
        this.head.searchConstraintHit(search);
        this.tail.searchConstraintHit(search);
    }
}

