/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.report;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.Error;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.Path;
import gov.nasa.jpf.jvm.StackFrame;
import gov.nasa.jpf.jvm.Step;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.Transition;
import gov.nasa.jpf.report.Publisher;
import gov.nasa.jpf.report.Reporter;
import gov.nasa.jpf.report.Statistics;
import gov.nasa.jpf.util.RepositoryEntry;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class XMLPublisher
extends Publisher {
    public XMLPublisher(Config conf, Reporter reporter) {
        super(conf, reporter);
    }

    @Override
    public String getName() {
        return "xml";
    }

    @Override
    protected void openChannel() {
        if (this.out == null) {
            String fname = this.getReportFileName("jpf.report.xml.file") + ".xml";
            try {
                this.out = new PrintWriter(fname);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void closeChannel() {
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
    }

    @Override
    protected void publishProlog() {
        this.out.println("<?xml version=\"1.0\" ?>");
        this.out.println("<jpfreport>");
    }

    @Override
    public void publishTopicStart(String topic) {
        this.out.println("  <" + topic + ">");
    }

    @Override
    public void publishTopicEnd(String topic) {
        this.out.println("  </" + topic + ">");
    }

    @Override
    protected void publishEpilog() {
        this.out.println("</jpfreport>");
    }

    @Override
    protected void publishJPF() {
        this.out.println("  <jpf-version>" + JPF.VERSION + "</jpf-version>");
    }

    @Override
    protected void publishJPFConfig() {
        String defSrc;
        TreeMap<Object, Object> map = this.conf.asOrderedMap();
        Set<Map.Entry<Object, Object>> eSet = map.entrySet();
        String src = this.conf.getSourceName();
        if (src == null) {
            src = "?";
        }
        if ((defSrc = this.conf.getDefaultsSourceName()) == null) {
            defSrc = "?";
        }
        String[] args = this.conf.getArgs();
        this.out.println("  <jpf-properties");
        this.out.println("                 defaults=\"" + defSrc + "\"");
        this.out.println("                 src=\"" + src + "\">");
        for (Map.Entry<Object, Object> e : eSet) {
            this.out.println("    <entry key=\"" + e.getKey() + "\" value=\"" + e.getValue() + "\"/>");
        }
        this.out.println("  </jpf-properties>");
        this.out.print("  <jpf-args>");
        for (String s : args) {
            this.out.print(s);
            this.out.print(' ');
        }
        this.out.println("</jpf-args>");
    }

    @Override
    protected void publishPlatform() {
        this.out.println("  <platform>");
        this.out.println("    <hostname>" + this.reporter.getHostName() + "</hostname>");
        this.out.println("    <arch>" + this.reporter.getArch() + "</arch>");
        this.out.println("    <os>" + this.reporter.getOS() + "</os>");
        this.out.println("    <java>" + this.reporter.getJava() + "</java>");
        this.out.println("  </platform>");
    }

    @Override
    protected void publishUser() {
        this.out.println("  <user>" + this.reporter.getUser() + "</user>");
    }

    @Override
    protected void publishDTG() {
        this.out.println("  <started>" + this.reporter.getStartDate() + "</started>");
    }

    @Override
    protected void publishSuT() {
        this.out.println("  <sut>");
        String mainCls = this.conf.getTargetArg();
        if (mainCls != null) {
            String mainPath = this.reporter.getSuT();
            if (mainPath != null) {
                this.out.println("    <source>" + mainPath + "</source>");
                RepositoryEntry rep = RepositoryEntry.getRepositoryEntry(mainPath);
                if (rep != null) {
                    this.out.println("    <repository>" + rep.getRepository() + "</repository>");
                    this.out.println("    <revision>" + rep.getRevision() + "</revision>");
                }
            } else {
                this.out.println("    <binary>" + mainCls + ".class" + "</binary>");
            }
        }
        this.out.println("  </sut>");
    }

    @Override
    protected void publishResult() {
        List<Error> errors = this.reporter.getErrors();
        this.out.print("  <result findings=\"");
        if (errors.isEmpty()) {
            this.out.println("none\"/>");
        } else {
            this.out.println("errors\">");
            int i = 0;
            for (Error e : errors) {
                this.out.print("    <error id=\"");
                this.out.print(i++);
                this.out.println("\">");
                this.out.print("      <property>");
                this.out.print(e.getProperty().getClass().getName());
                this.out.println("</property>");
                this.out.print("      <details>");
                this.out.print(e.getDetails());
                this.out.println("      </details>");
                this.out.println("    </error>");
            }
            this.out.println("  </result>");
        }
    }

    @Override
    protected void publishTrace() {
        Path path = this.reporter.getPath();
        int i = 0;
        if (path.size() == 0) {
            return;
        }
        this.out.println("  <trace>");
        for (Transition t : path) {
            ChoiceGenerator cg = t.getChoiceGenerator();
            this.out.println("    <transition id=\"" + i++ + "\" thread=\"" + t.getThreadIndex() + "\">");
            this.out.println("      <cg class=\"" + cg.getClass().getName() + "\" choice=\"" + cg.getProcessedNumberOfChoices() + "\"/>");
            for (Step s : t) {
                this.out.print("      <insn src=\"" + s.getLocationString() + "\">");
                String insn = s.getInstruction().toString();
                if (insn.indexOf(60) >= 0) {
                    insn = insn.replaceAll("<", "&lt;");
                    insn = insn.replaceAll(">", "&gt;");
                }
                this.out.print(insn);
                this.out.println("</insn>");
            }
            this.out.println("    </transition>");
        }
        this.out.println("  </trace>");
    }

    @Override
    protected void publishOutput() {
        Path path = this.reporter.getPath();
        if (path.size() == 0) {
            return;
        }
        if (path.hasOutput()) {
            this.out.println("  <output>");
            for (Transition t : path) {
                String s = t.getOutput();
                if (s == null) continue;
                this.out.print(s);
            }
            this.out.println("  </output>");
        }
    }

    @Override
    protected void publishSnapshot() {
        JVM vm = this.reporter.getVM();
        this.out.println("  <live-threads>");
        for (ThreadInfo ti : vm.getLiveThreads()) {
            this.out.println("    <thread id=\"" + ti.getIndex() + "\" name=\"" + ti.getName() + "\" status=\"" + ti.getStatusName() + "\">");
            for (ElementInfo e : ti.getLockedObjects()) {
                this.out.println("      <lock-owned object=\"" + e + "\"/>");
            }
            ElementInfo ei = ti.getLockObject();
            if (ei != null) {
                this.out.println("      <lock-request object=\"" + ei + "\"/>");
            }
            List<StackFrame> callStack = ti.getStack();
            Collections.reverse(callStack);
            for (StackFrame frame : callStack) {
                if (frame.isDirectCallFrame()) continue;
                this.out.println("      <frame>" + frame.getStackTraceInfo() + "</frame>");
            }
            this.out.println("    </thread>");
        }
        this.out.println("  </live-threads>");
    }

    @Override
    protected void publishStatistics() {
        Statistics stat = this.reporter.getStatistics();
        this.out.println("  <statistics>");
        this.out.println("    <elapsed-time>" + XMLPublisher.formatHMS(this.reporter.getElapsedTime()) + "</elapsed-time>");
        this.out.println("    <new-states>" + stat.newStates + "</new-states>");
        this.out.println("    <visited-states>" + stat.visitedStates + "</visited-states>");
        this.out.println("    <backtracked-states>" + stat.backtracked + "</backtracked-states>");
        this.out.println("    <end-states>" + stat.endStates + "</end-states>");
        this.out.println("    <max-memory unit=\"MB\">" + (stat.maxUsed >> 20) + "</max-memory>");
        this.out.println("  </statistics>");
    }
}

