/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.report;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.Error;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.JPFListener;
import gov.nasa.jpf.ListenerAdapter;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.Path;
import gov.nasa.jpf.report.Publisher;
import gov.nasa.jpf.report.PublisherExtension;
import gov.nasa.jpf.report.Statistics;
import gov.nasa.jpf.search.Search;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;

public class Reporter
extends ListenerAdapter {
    public static Logger log = JPF.getLogger("gov.nasa.jpf.report");
    protected Config conf;
    protected JPF jpf;
    protected Search search;
    protected JVM vm;
    protected Date started;
    protected Date finished;
    protected Statistics stat;
    protected Publisher[] publishers;

    public Reporter(Config conf, JPF jpf) throws Config.Exception {
        this.conf = conf;
        this.jpf = jpf;
        this.search = jpf.getSearch();
        this.vm = jpf.getVM();
        boolean reportStats = false;
        this.started = new Date();
        for (Publisher publisher : this.publishers = this.createPublishers(conf)) {
            if (reportStats || publisher.hasToReportStatistics()) {
                reportStats = true;
            }
            if (!(publisher instanceof JPFListener)) continue;
            jpf.addListener((JPFListener)((Object)publisher));
        }
        if (reportStats) {
            this.stat = conf.getInstance("jpf.report.statistics.class", Statistics.class);
            if (this.stat == null) {
                this.stat = new Statistics();
            }
            jpf.addListener(this.stat);
        }
    }

    Publisher[] createPublishers(Config conf) throws Config.Exception {
        String[] def = new String[]{"gov.nasa.jpf.report.ConsolePublisher"};
        ArrayList<Publisher> list = new ArrayList<Publisher>();
        Class[] argTypes = new Class[]{Config.class, Reporter.class};
        Object[] args = new Object[]{conf, this};
        for (String id : conf.getStringArray("jpf.report.publisher", def)) {
            Publisher p = conf.getInstance("jpf.report." + id + ".class", Publisher.class, argTypes, args);
            if (p != null) {
                list.add(p);
                continue;
            }
            log.warning("could not instantiate publisher class: " + id);
        }
        return list.toArray(new Publisher[list.size()]);
    }

    public void addListener(JPFListener listener) {
        this.jpf.addListener(listener);
    }

    public Publisher[] getPublishers() {
        return this.publishers;
    }

    public boolean hasToReportTrace() {
        for (Publisher p : this.publishers) {
            if (!p.hasTopic("trace")) continue;
            return true;
        }
        return false;
    }

    public boolean hasToReportOutput() {
        for (Publisher p : this.publishers) {
            if (!p.hasTopic("output")) continue;
            return true;
        }
        return false;
    }

    public <T extends Publisher> boolean addPublisherExtension(Class<T> publisherCls, PublisherExtension e) {
        for (Publisher p : this.publishers) {
            if (!publisherCls.isInstance(p)) continue;
            p.addExtension(e);
            return true;
        }
        return false;
    }

    public <T extends Publisher> void setPublisherTopics(Class<T> publisherCls, int category, String[] topics) {
        for (Publisher p : this.publishers) {
            if (!publisherCls.isInstance(p)) continue;
            p.setTopics(category, topics);
            return;
        }
    }

    boolean contains(String key, String[] list) {
        for (String s : list) {
            if (!s.equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    protected void publishStart() {
        for (Publisher publisher : this.publishers) {
            publisher.openChannel();
            publisher.publishProlog();
            publisher.publishStart();
        }
    }

    protected void publishTransition() {
        for (Publisher publisher : this.publishers) {
            publisher.publishTransition();
        }
    }

    protected void publishPropertyViolation() {
        for (Publisher publisher : this.publishers) {
            publisher.publishPropertyViolation();
        }
    }

    protected void publishConstraintHit() {
        for (Publisher publisher : this.publishers) {
            publisher.publishConstraintHit();
        }
    }

    protected void publishFinished() {
        for (Publisher publisher : this.publishers) {
            publisher.publishFinished();
            publisher.publishEpilog();
            publisher.closeChannel();
        }
    }

    @Override
    public void searchStarted(Search search) {
        this.publishStart();
    }

    @Override
    public void stateAdvanced(Search search) {
        this.publishTransition();
    }

    @Override
    public void searchConstraintHit(Search search) {
        this.publishConstraintHit();
    }

    @Override
    public void propertyViolated(Search search) {
        this.publishPropertyViolation();
    }

    @Override
    public void searchFinished(Search search) {
        this.finished = new Date();
        this.publishFinished();
    }

    public Date getStartDate() {
        return this.started;
    }

    public Date getFinishedDate() {
        return this.finished;
    }

    public JVM getVM() {
        return this.vm;
    }

    public Search getSearch() {
        return this.search;
    }

    public List<Error> getErrors() {
        return this.search.getErrors();
    }

    public Error getLastError() {
        return this.search.getLastError();
    }

    public String getLastSearchConstraint() {
        return this.search.getLastSearchContraint();
    }

    public String getLastErrorId() {
        Error e = this.getLastError();
        if (e != null) {
            return "#" + e.getId();
        }
        return "";
    }

    public int getNumberOfErrors() {
        return this.search.getErrors().size();
    }

    public Statistics getStatistics() {
        return this.stat;
    }

    public Statistics getStatisticsSnapshot() {
        return this.stat.clone();
    }

    public long getElapsedTime() {
        Date d = this.finished != null ? this.finished : new Date();
        long t = d.getTime() - this.started.getTime();
        return t;
    }

    public Path getPath() {
        return this.vm.getClonedPath();
    }

    public String getJPFBanner() {
        String repInfo;
        String s = "JavaPathfinder v" + JPF.VERSION + " - (C) 1999-2007 RIACS/NASA Ames Research Center";
        if (this.conf.getBoolean("jpf.report.show_repository", false) && (repInfo = this.getRepositoryInfo()) != null) {
            s = s + repInfo;
        }
        return s;
    }

    String getRepositoryInfo() {
        String dir = this.conf.getString("jpf.basedir");
        dir = dir != null ? dir + File.separatorChar + ".svn" : ".svn";
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            File f = new File(dir, "entries");
            if (f.exists()) {
                FileInputStream fis = new FileInputStream(f);
                BufferedReader br = new BufferedReader(new InputStreamReader(fis));
                String line = br.readLine();
                while (line != null) {
                    if (line.equals("dir") && (line = br.readLine()) != null) {
                        pw.println();
                        pw.print("(r");
                        pw.print(line);
                        line = br.readLine();
                        if (line != null) {
                            String repository = line;
                            br.readLine();
                            while ((line = br.readLine()) != null && line.equals("")) {
                            }
                            if (!line.matches("\\d\\d\\d\\d-\\d\\d-\\d\\dT.*")) break;
                            String dtg = line.substring(0, 19);
                            pw.print(" ");
                            pw.print(dtg);
                            pw.println(')');
                            pw.print(repository);
                            break;
                        }
                        pw.print(')');
                        break;
                    }
                    line = br.readLine();
                }
                return sw.toString();
            }
        }
        catch (IOException iox) {
            // empty catch block
        }
        return null;
    }

    public String getHostName() {
        try {
            InetAddress in = InetAddress.getLocalHost();
            String hostName = in.getHostName();
            return hostName;
        }
        catch (Throwable t) {
            return "localhost";
        }
    }

    public String getUser() {
        return System.getProperty("user.name");
    }

    public String getSuT() {
        String mainCls = this.vm.getMainClassName();
        ClassInfo ciMain = ClassInfo.getClassInfo(mainCls);
        return ciMain.getSourceFileName();
    }

    public String getJava() {
        String vendor = System.getProperty("java.vendor");
        String version = System.getProperty("java.version");
        return vendor + "/" + version;
    }

    public String getArch() {
        String arch = System.getProperty("os.arch");
        Runtime rt = Runtime.getRuntime();
        String type = arch + "/" + rt.availableProcessors();
        return type;
    }

    public String getOS() {
        String name = System.getProperty("os.name");
        String version = System.getProperty("os.version");
        return name + "/" + version;
    }
}

