/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.report;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.report.PublisherExtension;
import gov.nasa.jpf.report.Reporter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;

public abstract class Publisher {
    public static final int START = 1;
    public static final int TRANSITION = 2;
    public static final int PROPERTY_VIOLATION = 3;
    public static final int FINISHED = 4;
    protected Config conf;
    protected Reporter reporter;
    protected String[] startTopics = new String[0];
    protected String[] transitionTopics = new String[0];
    protected String[] propertyViolationTopics = new String[0];
    protected String[] constraintTopics = new String[0];
    protected String[] finishedTopics = new String[0];
    DateFormat dtgFormatter = DateFormat.getDateTimeInstance(3, 3);
    ArrayList<PublisherExtension> extensions;
    protected PrintWriter out;

    public PrintWriter getOut() {
        return this.out;
    }

    protected Publisher(Config conf, Reporter reporter) {
        this.conf = conf;
        this.reporter = reporter;
        this.setTopics();
    }

    public void setTopics(int category, String[] newTopics) {
        switch (category) {
            case 1: {
                this.startTopics = newTopics;
                break;
            }
            case 2: {
                this.transitionTopics = newTopics;
                break;
            }
            case 3: {
                this.propertyViolationTopics = newTopics;
                break;
            }
            case 4: {
                this.finishedTopics = newTopics;
                break;
            }
            default: {
                Reporter.log.warning("unknown publisher topic category: " + category);
            }
        }
    }

    public abstract String getName();

    protected void setTopics() {
        this.setTopics(this.getName());
    }

    protected void setTopics(String name) {
        String prefix = "jpf.report." + name;
        this.startTopics = this.conf.getStringArray(prefix + ".start", this.startTopics);
        this.transitionTopics = this.conf.getStringArray(prefix + ".transition", this.transitionTopics);
        this.propertyViolationTopics = this.conf.getStringArray(prefix + ".property_violation", this.propertyViolationTopics);
        this.constraintTopics = this.conf.getStringArray(prefix + ".constraint", this.constraintTopics);
        this.finishedTopics = this.conf.getStringArray(prefix + ".finished", this.finishedTopics);
    }

    public void addExtension(PublisherExtension ext) {
        if (this.extensions == null) {
            this.extensions = new ArrayList();
        }
        this.extensions.add(ext);
    }

    public String getLastErrorId() {
        return this.reporter.getLastErrorId();
    }

    public boolean hasTopic(String topic) {
        for (String s : this.startTopics) {
            if (!s.equalsIgnoreCase(topic)) continue;
            return true;
        }
        for (String s : this.transitionTopics) {
            if (!s.equalsIgnoreCase(topic)) continue;
            return true;
        }
        for (String s : this.propertyViolationTopics) {
            if (!s.equalsIgnoreCase(topic)) continue;
            return true;
        }
        for (String s : this.finishedTopics) {
            if (!s.equalsIgnoreCase(topic)) continue;
            return true;
        }
        return false;
    }

    public String formatDTG(Date date) {
        return this.dtgFormatter.format(date);
    }

    public static String formatHMS(long t) {
        long s = (t /= 1000L) % 60L;
        long h = t / 3600L;
        long m = t % 3600L / 60L;
        StringBuilder sb = new StringBuilder();
        sb.append(h);
        sb.append(':');
        if (m < 10L) {
            sb.append('0');
        }
        sb.append(m);
        sb.append(':');
        if (s < 10L) {
            sb.append('0');
        }
        sb.append(s);
        return sb.toString();
    }

    public String getReportFileName(String key) {
        String fname = this.conf.getString(key);
        if (fname == null && (fname = this.conf.getString("jpf.report.file")) == null) {
            fname = "report";
        }
        return fname;
    }

    public void publishTopicStart(String topic) {
    }

    public void publishTopicEnd(String topic) {
    }

    public boolean hasToReportStatistics() {
        for (String s : this.finishedTopics) {
            if (!"statistics".equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    protected void openChannel() {
    }

    protected void closeChannel() {
    }

    public void publishStart() {
        for (String topic : this.startTopics) {
            if ("jpf".equalsIgnoreCase(topic)) {
                this.publishJPF();
                continue;
            }
            if ("platform".equalsIgnoreCase(topic)) {
                this.publishPlatform();
                continue;
            }
            if ("user".equalsIgnoreCase(topic)) continue;
            if ("dtg".equalsIgnoreCase(topic)) {
                this.publishDTG();
                continue;
            }
            if ("config".equalsIgnoreCase(topic)) {
                this.publishJPFConfig();
                continue;
            }
            if (!"sut".equalsIgnoreCase(topic)) continue;
            this.publishSuT();
        }
        if (this.extensions != null) {
            for (PublisherExtension e : this.extensions) {
                e.publishStart(this);
            }
        }
    }

    public void publishTransition() {
        if (this.extensions != null) {
            for (PublisherExtension e : this.extensions) {
                e.publishTransition(this);
            }
        }
    }

    public void publishConstraintHit() {
        for (String topic : this.constraintTopics) {
            if ("constraint".equalsIgnoreCase(topic)) {
                this.publishConstraint();
                continue;
            }
            if ("trace".equalsIgnoreCase(topic)) {
                this.publishTrace();
                continue;
            }
            if ("snapshot".equalsIgnoreCase(topic)) {
                this.publishSnapshot();
                continue;
            }
            if ("output".equalsIgnoreCase(topic)) {
                this.publishOutput();
                continue;
            }
            if (!"statistics".equalsIgnoreCase(topic)) continue;
            this.publishStatistics();
        }
        if (this.extensions != null) {
            for (PublisherExtension publisherExtension : this.extensions) {
            }
        }
    }

    public void publishPropertyViolation() {
        for (String topic : this.propertyViolationTopics) {
            if ("error".equalsIgnoreCase(topic)) {
                this.publishError();
                continue;
            }
            if ("trace".equalsIgnoreCase(topic)) {
                this.publishTrace();
                continue;
            }
            if ("snapshot".equalsIgnoreCase(topic)) {
                this.publishSnapshot();
                continue;
            }
            if ("output".equalsIgnoreCase(topic)) {
                this.publishOutput();
                continue;
            }
            if (!"statistics".equalsIgnoreCase(topic)) continue;
            this.publishStatistics();
        }
        if (this.extensions != null) {
            for (PublisherExtension e : this.extensions) {
                e.publishPropertyViolation(this);
            }
        }
    }

    public void publishFinished() {
        if (this.extensions != null) {
            for (PublisherExtension e : this.extensions) {
                e.publishFinished(this);
            }
        }
        for (String topic : this.finishedTopics) {
            if ("result".equalsIgnoreCase(topic)) {
                this.publishResult();
                continue;
            }
            if (!"statistics".equalsIgnoreCase(topic)) continue;
            this.publishStatistics();
        }
    }

    protected void publishProlog() {
    }

    protected void publishEpilog() {
    }

    protected void publishJPF() {
    }

    protected void publishJPFConfig() {
    }

    protected void publishPlatform() {
    }

    protected void publishUser() {
    }

    protected void publishDTG() {
    }

    protected void publishJava() {
    }

    protected void publishSuT() {
    }

    protected void publishResult() {
    }

    protected void publishError() {
    }

    protected void publishConstraint() {
    }

    protected void publishTrace() {
    }

    protected void publishOutput() {
    }

    protected void publishSnapshot() {
    }

    protected void publishStatistics() {
    }
}

