/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.report;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.Error;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.Path;
import gov.nasa.jpf.jvm.Step;
import gov.nasa.jpf.jvm.Transition;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.report.Publisher;
import gov.nasa.jpf.report.Reporter;
import gov.nasa.jpf.report.Statistics;
import gov.nasa.jpf.util.Left;
import gov.nasa.jpf.util.RepositoryEntry;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ConsolePublisher
extends Publisher {
    String fileName;
    FileOutputStream fos;
    String port;
    boolean showCG;
    boolean showSteps;
    boolean showLocation;
    boolean showSource;
    boolean showMethod;
    boolean showCode;

    public ConsolePublisher(Config conf, Reporter reporter) {
        super(conf, reporter);
        this.fileName = conf.getString("jpf.report.console.file");
        this.port = conf.getString("jpf.report.console.port");
        this.showCG = conf.getBoolean("jpf.report.console.show_cg", true);
        this.showSteps = conf.getBoolean("jpf.report.console.show_steps", true);
        this.showLocation = conf.getBoolean("jpf.report.console.show_location", true);
        this.showSource = conf.getBoolean("jpf.report.console.show_source", true);
        this.showMethod = conf.getBoolean("jpf.report.console.show_method", false);
        this.showCode = conf.getBoolean("jpf.report.console.show_code", false);
    }

    @Override
    public String getName() {
        return "console";
    }

    @Override
    protected void openChannel() {
        if (this.fileName != null) {
            try {
                this.fos = new FileOutputStream(this.fileName);
                this.out = new PrintWriter(this.fos);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        } else if (this.port != null) {
            // empty if block
        }
        if (this.out == null) {
            this.out = new PrintWriter(System.out, true);
        }
    }

    @Override
    protected void closeChannel() {
        if (this.fos != null) {
            this.out.close();
        }
    }

    @Override
    public void publishTopicStart(String topic) {
        this.out.println();
        this.out.print("====================================================== ");
        this.out.println(topic);
    }

    @Override
    public void publishTopicEnd(String topic) {
    }

    @Override
    public void publishStart() {
        super.publishStart();
        this.publishTopicStart("search started: " + this.formatDTG(this.reporter.getStartDate()));
    }

    @Override
    public void publishFinished() {
        super.publishFinished();
        this.publishTopicStart("search finished: " + this.formatDTG(this.reporter.getFinishedDate()));
    }

    @Override
    protected void publishJPF() {
        this.out.println(this.reporter.getJPFBanner());
        this.out.println();
    }

    @Override
    protected void publishDTG() {
        this.out.println("started: " + this.reporter.getStartDate());
    }

    @Override
    protected void publishUser() {
        this.out.println("user: " + this.reporter.getUser());
    }

    @Override
    protected void publishJPFConfig() {
        String defSrc;
        this.publishTopicStart("JPF configuration");
        TreeMap<Object, Object> map = this.conf.asOrderedMap();
        Set<Map.Entry<Object, Object>> eSet = map.entrySet();
        String src = this.conf.getSourceName();
        if (src == null) {
            src = "?";
        }
        if ((defSrc = this.conf.getDefaultsSourceName()) == null) {
            defSrc = "?";
        }
        String[] args = this.conf.getArgs();
        this.out.println("property: " + src);
        this.out.println("property-defaults: " + defSrc);
        this.out.println("properties:");
        for (Map.Entry<Object, Object> e : eSet) {
            this.out.println("  " + e.getKey() + "=" + e.getValue());
        }
        this.out.print("args: ");
        for (String s : args) {
            this.out.print(s);
            this.out.print(' ');
        }
        this.out.println();
    }

    @Override
    protected void publishPlatform() {
        this.publishTopicStart("platform");
        this.out.println("hostname: " + this.reporter.getHostName());
        this.out.println("arch: " + this.reporter.getArch());
        this.out.println("os: " + this.reporter.getOS());
        this.out.println("java: " + this.reporter.getJava());
    }

    @Override
    protected void publishSuT() {
        this.publishTopicStart("system under test");
        String mainCls = this.conf.getTargetArg();
        if (mainCls != null) {
            String mainPath = this.reporter.getSuT();
            if (mainPath != null) {
                this.out.println("application: " + mainPath);
                RepositoryEntry rep = RepositoryEntry.getRepositoryEntry(mainPath);
                if (rep != null) {
                    this.out.println("repository: " + rep.getRepository());
                    this.out.println("revision: " + rep.getRevision());
                }
            } else {
                this.out.println("application: " + mainCls + ".class");
            }
        } else {
            this.out.println("application: ?");
        }
        String[] args = this.conf.getTargetArgParameters();
        if (args.length > 0) {
            this.out.print("arguments:   ");
            for (String s : args) {
                this.out.print(s);
                this.out.print(' ');
            }
            this.out.println();
        }
    }

    @Override
    protected void publishError() {
        Error e = this.reporter.getLastError();
        this.publishTopicStart("error " + this.reporter.getLastErrorId());
        this.out.println(e.getDescription());
        String s = e.getDetails();
        if (s != null) {
            this.out.println(s);
        }
    }

    @Override
    protected void publishConstraint() {
        String constraint = this.reporter.getLastSearchConstraint();
        this.publishTopicStart("search constraint");
        this.out.println(constraint);
    }

    @Override
    protected void publishResult() {
        List<Error> errors = this.reporter.getErrors();
        this.publishTopicStart("results");
        if (errors.isEmpty()) {
            this.out.println("no errors detected");
        } else {
            for (Error e : errors) {
                this.out.print("error #");
                this.out.print(e.getId());
                this.out.print(": ");
                this.out.print(e.getDescription());
                String s = e.getDetails();
                if (s != null) {
                    s = s.replace('\n', ' ');
                    s = s.replace('\t', ' ');
                    s = s.replace('\r', ' ');
                    this.out.print(" \"");
                    if (s.length() > 50) {
                        this.out.print(s.substring(0, 50));
                        this.out.print("...");
                    } else {
                        this.out.print(s);
                    }
                    this.out.print('\"');
                }
                this.out.println();
            }
        }
    }

    @Override
    protected void publishTrace() {
        Path path = this.reporter.getPath();
        int i = 0;
        if (path.size() == 0) {
            return;
        }
        this.publishTopicStart("trace " + this.reporter.getLastErrorId());
        for (Transition t : path) {
            this.out.print("------------------------------------------------------ ");
            this.out.println("transition #" + i++ + " thread: " + t.getThreadIndex());
            if (this.showCG) {
                this.out.println(t.getChoiceGenerator());
            }
            if (!this.showSteps) continue;
            Step last = null;
            MethodInfo lastMi = null;
            int nNoSrc = 0;
            for (Step s : t) {
                MethodInfo mi;
                if (this.showSource) {
                    if (!s.equals(last)) {
                        String line = s.getLineString();
                        if (line != null) {
                            if (nNoSrc > 0) {
                                this.out.println("      [" + nNoSrc + " insn w/o sources]");
                            }
                            this.out.print("  ");
                            if (this.showLocation) {
                                this.out.print(Left.format(s.getLocationString(), 30));
                                this.out.print(" : ");
                            }
                            this.out.println(line.trim());
                            nNoSrc = 0;
                        } else {
                            ++nNoSrc;
                        }
                    }
                    last = s;
                }
                if (!this.showCode) continue;
                Instruction insn = s.getInstruction();
                if (this.showMethod && (mi = insn.getMethodInfo()) != lastMi) {
                    ClassInfo mci = mi.getClassInfo();
                    this.out.print("    ");
                    if (mci != null) {
                        this.out.print(mci.getName());
                        this.out.print(".");
                    }
                    this.out.println(mi.getUniqueName());
                    lastMi = mi;
                }
                this.out.print("      ");
                this.out.println(insn);
            }
            if (!this.showSource || this.showCode || nNoSrc <= 0) continue;
            this.out.println("      [" + nNoSrc + " insn w/o sources]");
        }
    }

    @Override
    protected void publishOutput() {
        Path path = this.reporter.getPath();
        if (path.size() == 0) {
            return;
        }
        this.publishTopicStart("output " + this.reporter.getLastErrorId());
        if (path.hasOutput()) {
            for (Transition t : path) {
                String s = t.getOutput();
                if (s == null) continue;
                this.out.print(s);
            }
        } else {
            this.out.println("no output");
        }
    }

    @Override
    protected void publishSnapshot() {
        JVM vm = this.reporter.getVM();
        this.publishTopicStart("snapshot " + this.reporter.getLastErrorId());
        if (vm.getPathLength() > 0) {
            vm.printLiveThreadStatus(this.out);
        } else {
            this.out.println("initial program state");
        }
    }

    @Override
    protected void publishStatistics() {
        Statistics stat = this.reporter.getStatistics();
        this.publishTopicStart("statistics");
        this.out.println("elapsed time:       " + ConsolePublisher.formatHMS(this.reporter.getElapsedTime()));
        this.out.println("states:             new=" + stat.newStates + ", visited=" + stat.visitedStates + ", backtracked=" + stat.backtracked + ", end=" + stat.endStates);
        this.out.println("search:             maxDepth=" + stat.maxDepth + ", constraints=" + stat.constraints);
        this.out.println("choice generators:  thread=" + stat.threadCGs + ", data=" + stat.dataCGs);
        this.out.println("heap:               gc=" + stat.gcCycles + ", new=" + stat.nObjects + ", free=" + stat.nRecycled);
        this.out.println("instructions:       " + stat.insns);
        this.out.println("max memory:         " + (stat.maxUsed >> 20) + "MB");
        this.out.println("loaded code:        classes=" + ClassInfo.getNumberOfLoadedClasses() + ", methods=" + MethodInfo.getNumberOfLoadedMethods());
    }
}

