/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.untracked;

import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.Fields;
import java.util.HashSet;
import java.util.LinkedList;

public class UntrackedManager {
    private static UntrackedManager manager = null;
    private static boolean untrackedProperty = false;

    private UntrackedManager() {
    }

    public static UntrackedManager getInstance() {
        if (manager == null && untrackedProperty) {
            manager = new UntrackedManager();
        }
        return manager;
    }

    public static boolean getProperty() {
        return untrackedProperty;
    }

    public static void setProperty(boolean prop) {
        untrackedProperty = prop;
    }

    public void oldObjectsTraversal(int objref) {
        if (objref == -1) {
            return;
        }
        DynamicArea da = DynamicArea.getHeap();
        if (da.get(objref) == null) {
            return;
        }
        HashSet<Integer> visited = new HashSet<Integer>();
        LinkedList<Integer> list = new LinkedList<Integer>();
        this.addRef(objref, visited, list);
        while (!list.isEmpty()) {
            int i;
            int numOfFields;
            int index = list.removeFirst();
            Object ei = da.get(index);
            Fields fields = ((ElementInfo)ei).getFields();
            fields.decUntracked();
            if (fields.isUntracked()) continue;
            if (fields.isReferenceArray()) {
                numOfFields = fields.size();
                for (i = 0; i < numOfFields; ++i) {
                    int childObjref = fields.getReferenceValue(i);
                    if (childObjref == -1) continue;
                    this.addRef(childObjref, visited, list);
                }
                continue;
            }
            numOfFields = fields.getNumberOfFields();
            for (i = 0; i < numOfFields; ++i) {
                int childObjref;
                FieldInfo fi = ((ElementInfo)ei).getFieldInfo(i);
                if (!fi.isReference() || (childObjref = fields.getReferenceValue(fi.getStorageOffset())) == -1) continue;
                this.addRef(childObjref, visited, list);
            }
        }
    }

    public void newObjectsTraversal(int objref) {
        if (objref == -1) {
            return;
        }
        DynamicArea da = DynamicArea.getHeap();
        if (da.get(objref) == null) {
            return;
        }
        HashSet<Integer> visited = new HashSet<Integer>();
        LinkedList<Integer> list = new LinkedList<Integer>();
        this.addRef(objref, visited, list);
        while (!list.isEmpty()) {
            int index = list.removeFirst();
            Object ei = da.get(index);
            Fields fields = ((ElementInfo)ei).getFields();
            if (!fields.isUntracked()) {
                int i;
                int numOfFields;
                if (fields.isReferenceArray()) {
                    numOfFields = fields.size();
                    for (i = 0; i < numOfFields; ++i) {
                        int childObjref = fields.getReferenceValue(i);
                        if (childObjref == -1) continue;
                        this.addRef(childObjref, visited, list);
                    }
                } else {
                    numOfFields = fields.getNumberOfFields();
                    for (i = 0; i < numOfFields; ++i) {
                        int childObjref;
                        FieldInfo fi = ((ElementInfo)ei).getFieldInfo(i);
                        if (!fi.isReference() || (childObjref = fields.getReferenceValue(fi.getStorageOffset())) == -1) continue;
                        this.addRef(childObjref, visited, list);
                    }
                }
            }
            fields.incUntracked();
        }
    }

    private void addRef(int ref, HashSet<Integer> visited, LinkedList<Integer> queue) {
        Integer r = new Integer(ref);
        if (!visited.contains(r)) {
            visited.add(r);
            queue.add(r);
        }
    }

    public void restoreTrackedFields(ElementInfo ei, Fields f) {
        Fields fields = ei.getFields();
        if (fields != null) {
            f.setUntracked(fields.getUntracked());
            if (fields.isUntracked()) {
                return;
            }
            int numOfFields = ei.getNumberOfFields();
            for (int i = 0; i < numOfFields; ++i) {
                FieldInfo fi = ei.getFieldInfo(i);
                if (!fi.isUntracked()) continue;
                int storageSize = fi.getStorageSize();
                int storageOffset = fi.getStorageOffset();
                for (int j = 0; j < storageSize; ++j) {
                    f.setIntValue(ei, storageOffset + j, fields.getIntValue(storageOffset + j));
                }
            }
        }
        ei.restoreFields(f);
    }

    public boolean isUntracked(ElementInfo ei) {
        Fields fields = ei.getFields();
        if (fields != null) {
            if (fields.isUntracked()) {
                return true;
            }
            int numOfFields = ei.getNumberOfFields();
            for (int i = 0; i < numOfFields; ++i) {
                FieldInfo fi = ei.getFieldInfo(i);
                if (!fi.isUntracked()) continue;
                return true;
            }
        }
        return false;
    }
}

