/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.untracked;

import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DynamicFields;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.untracked.UntrackedManager;

public class UntrackedDynamicFields
extends DynamicFields {
    protected int untracked;

    @Override
    public void setUntracked(int untracked) {
        this.untracked = untracked;
    }

    @Override
    public int getUntracked() {
        return this.untracked;
    }

    @Override
    public boolean isUntracked() {
        return this.untracked > 0;
    }

    @Override
    public void incUntracked() {
        ++this.untracked;
    }

    @Override
    public void decUntracked() {
        --this.untracked;
    }

    public UntrackedDynamicFields(String t, ClassInfo ci) {
        super(t, ci);
    }

    private boolean isFieldUntracked(int storageOffset) {
        FieldInfo fi = this.findFieldInfo(storageOffset);
        if (fi != null) {
            return fi.getAnnotation("gov.nasa.jpf.jvm.untracked.UntrackedField") != null;
        }
        return false;
    }

    @Override
    public void setReferenceValue(ElementInfo ei, int index, int newValue) {
        UntrackedManager manager = null;
        if (UntrackedManager.getProperty() && (this.untracked > 0 || this.isFieldUntracked(index))) {
            manager = UntrackedManager.getInstance();
            manager.oldObjectsTraversal(this.values[index]);
        }
        this.values[index] = newValue;
        if (manager != null) {
            manager.newObjectsTraversal(newValue);
        }
    }
}

