/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.choice;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.DynamicElementInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.ReferenceChoiceGenerator;
import java.util.ArrayList;

public class TypedObjectChoice
extends ReferenceChoiceGenerator {
    String type;
    int[] values;
    int count;

    public TypedObjectChoice(Config conf, String id) throws Config.Exception {
        DynamicArea heap = DynamicArea.getHeap();
        this.type = conf.getString(id + ".type");
        if (this.type == null) {
            throw conf.exception("missing 'type' property for TypedObjectGenerator " + id);
        }
        ArrayList<DynamicElementInfo> list = new ArrayList<DynamicElementInfo>();
        for (DynamicElementInfo ei : heap) {
            ClassInfo classInfo = ei.getClassInfo();
            if (!classInfo.isInstanceOf(this.type)) continue;
            list.add(ei);
        }
        this.values = new int[list.size()];
        int i = 0;
        for (ElementInfo elementInfo : list) {
            this.values[i++] = elementInfo.getIndex();
        }
        this.count = -1;
    }

    @Override
    public void advance() {
        ++this.count;
    }

    @Override
    public int getProcessedNumberOfChoices() {
        return this.count + 1;
    }

    @Override
    public int getTotalNumberOfChoices() {
        return this.values.length;
    }

    @Override
    public boolean hasMoreChoices() {
        return !this.isDone && this.count < this.values.length - 1;
    }

    @Override
    public void reset() {
        this.count = -1;
    }

    @Override
    public Integer getNextChoice() {
        if (this.count >= 0 && this.count < this.values.length) {
            return new Integer(this.values[this.count]);
        }
        return new Integer(-1);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("TypedObjectGenerator [id=");
        sb.append(this.id);
        sb.append(",type=");
        sb.append(this.type);
        sb.append(",values=");
        for (int i = 0; i < this.values.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            if (i == this.count) {
                sb.append("=>");
            }
            sb.append(this.values[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public TypedObjectChoice randomize() {
        for (int i = this.values.length - 1; i > 0; --i) {
            int j = random.nextInt(i + 1);
            int tmp = this.values[i];
            this.values[i] = this.values[j];
            this.values[j] = tmp;
        }
        return this;
    }
}

