/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.choice;

import gov.nasa.jpf.jvm.ThreadChoiceGenerator;
import gov.nasa.jpf.jvm.ThreadInfo;
import java.io.PrintWriter;

public class ThreadChoiceFromSet
extends ThreadChoiceGenerator {
    protected ThreadInfo[] values;
    protected int count;

    public ThreadChoiceFromSet(ThreadInfo[] set, boolean isSchedulingPoint) {
        super(isSchedulingPoint);
        this.values = set;
        this.count = -1;
    }

    @Override
    public void reset() {
        this.count = -1;
    }

    @Override
    public ThreadInfo getNextChoice() {
        if (this.count >= 0 && this.count < this.values.length) {
            return this.values[this.count];
        }
        return null;
    }

    @Override
    public boolean hasMoreChoices() {
        return !this.isDone && this.count < this.values.length - 1;
    }

    @Override
    public void advance() {
        if (this.count >= 0 && this.values[this.count].isTimedOut()) {
            this.values[this.count].resetTimedOut();
        }
        if (this.count < this.values.length - 1) {
            ++this.count;
            if (this.values[this.count].isTimeoutWaiting()) {
                this.values[this.count].setTimedOut();
            }
        }
    }

    @Override
    public int getTotalNumberOfChoices() {
        return this.values.length;
    }

    @Override
    public int getProcessedNumberOfChoices() {
        return this.count + 1;
    }

    public Object getNextChoiceObject() {
        return this.getNextChoice();
    }

    @Override
    public void printOn(PrintWriter pw) {
        pw.print(this.getClass().getName());
        pw.print(" {");
        for (int i = 0; i < this.values.length; ++i) {
            if (i > 0) {
                pw.print(',');
            }
            if (i == this.count) {
                pw.print('>');
            }
            pw.print(this.values[i].getName());
        }
        pw.print("}");
    }

    @Override
    public ThreadChoiceFromSet randomize() {
        for (int i = this.values.length - 1; i > 0; --i) {
            int j = random.nextInt(i + 1);
            ThreadInfo tmp = this.values[i];
            this.values[i] = this.values[j];
            this.values[j] = tmp;
        }
        return this;
    }

    public ThreadInfo[] getAllThreadChoices() {
        return this.values;
    }
}

