/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.choice;

import gov.nasa.jpf.jvm.IntChoiceGenerator;

public class RandomOrderIntCG
extends IntChoiceGenerator {
    protected int[] choices;
    protected int nextIdx;

    public RandomOrderIntCG(IntChoiceGenerator sub) {
        super(sub.id);
        int i;
        this.setPreviousChoiceGenerator(sub.getPreviousChoiceGenerator());
        this.choices = new int[sub.getTotalNumberOfChoices()];
        for (i = 0; i < this.choices.length; ++i) {
            sub.advance();
            this.choices[i] = sub.getNextChoice();
        }
        for (i = this.choices.length - 1; i > 0; --i) {
            int j = random.nextInt(i + 1);
            int tmp = this.choices[i];
            this.choices[i] = this.choices[j];
            this.choices[j] = tmp;
        }
        this.nextIdx = -1;
    }

    @Override
    public Integer getNextChoice() {
        return new Integer(this.choices[this.nextIdx]);
    }

    @Override
    public void advance() {
        if (this.nextIdx + 1 < this.choices.length) {
            ++this.nextIdx;
        }
    }

    @Override
    public int getProcessedNumberOfChoices() {
        return this.nextIdx + 1;
    }

    @Override
    public int getTotalNumberOfChoices() {
        return this.choices.length;
    }

    @Override
    public boolean hasMoreChoices() {
        return !this.isDone && this.nextIdx + 1 < this.choices.length;
    }

    @Override
    public void reset() {
        this.nextIdx = -1;
    }
}

