/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.choice;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.jvm.IntChoiceGenerator;

public class IntIntervalGenerator
extends IntChoiceGenerator {
    int min;
    int max;
    int next;
    int delta;

    @Override
    public void reset() {
        if (this.delta == 0) {
            throw new JPFException("IntIntervalGenerator delta value is 0");
        }
        if (this.min > this.max) {
            int t = this.max;
            this.max = this.min;
            this.min = t;
        }
        this.next = this.delta > 0 ? this.min - this.delta : this.max + this.delta;
    }

    public IntIntervalGenerator(int min, int max, int delta) {
        super(null);
        this.min = min;
        this.max = max;
        this.delta = delta;
        this.reset();
    }

    public IntIntervalGenerator(int min, int max) {
        this(min, max, 1);
    }

    public IntIntervalGenerator(Config conf, String id) {
        super(id);
        this.min = conf.getInt(id + ".min");
        this.max = conf.getInt(id + ".max");
        this.delta = conf.getInt(id + ".delta", 1);
        this.reset();
    }

    @Override
    public Integer getNextChoice() {
        return new Integer(this.next);
    }

    @Override
    public boolean hasMoreChoices() {
        if (this.isDone) {
            return false;
        }
        if (this.delta > 0) {
            return this.next < this.max;
        }
        return this.next > this.min;
    }

    @Override
    public void advance() {
        this.next += this.delta;
    }

    @Override
    public int getTotalNumberOfChoices() {
        return Math.abs(this.max - this.min) / this.delta + 1;
    }

    @Override
    public int getProcessedNumberOfChoices() {
        if (this.delta > 0 ? this.next < this.min : this.next > this.max) {
            return 0;
        }
        return Math.abs(this.next - this.min) / this.delta + 1;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        if (this.id == null) {
            sb.append('[');
        } else {
            sb.append("[id=\"");
            sb.append(this.id);
            sb.append("\",");
        }
        sb.append(this.min);
        sb.append("..");
        sb.append(this.max);
        sb.append(",delta=");
        if (this.delta > 0) {
            sb.append('+');
        }
        sb.append(this.delta);
        sb.append(",cur=");
        sb.append(this.getNextChoice());
        sb.append(']');
        return sb.toString();
    }
}

