/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.choice;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.choice.IntChoiceFromSet;
import gov.nasa.jpf.jvm.choice.IntSpec;
import java.util.HashMap;
import java.util.Map;

public class IntChoiceDependentSets
extends IntChoiceFromSet {
    String constraint_var;
    Map<String, String[]> value_map = new HashMap<String, String[]>();

    public IntChoiceDependentSets(Config conf, String id) {
        super(id);
        this.constraint_var = conf.getString(id + ".constrainedBy");
        int i = 0;
        String v = conf.getString(id + ".value" + i);
        while (v != null) {
            int colon = v.indexOf(58);
            if (v.length() <= colon) {
                throw new JPFException("IntChoiceDependentSets parse error on :" + id + ".value" + i + "=" + v);
            }
            String[] set = v.substring(colon + 1).trim().split("[, ]+");
            this.value_map.put(v.substring(0, colon), set);
            v = conf.getString(id + ".value" + ++i);
        }
        v = conf.getString(id + ".default");
    }

    public int getNextChoice(JVM vm) {
        if (this.count == 0) {
            int i;
            int len = this.value_map.size();
            int con_val = IntSpec.eval(this.constraint_var);
            Object[] keys = this.value_map.keySet().toArray();
            for (i = 0; i < len && con_val != IntSpec.eval((String)keys[i]); ++i) {
            }
            if (i < len) {
                this.values = this.value_map.get(keys[i]);
            } else {
                this.values = this.value_map.get("default");
                if (this.values == null) {
                    throw new JPFException("no value match, no default found");
                }
            }
        }
        int ret = IntSpec.eval(this.values[this.count]);
        vm.println("Choice: " + this.id + " = " + this.values[this.count] + "(" + ret + ")");
        return ret;
    }
}

