/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.choice;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.DoubleChoiceGenerator;

public class DoubleThresholdGenerator
extends DoubleChoiceGenerator {
    double[] values = new double[3];
    int count;

    public DoubleThresholdGenerator(Config conf, String id) {
        super(id);
        this.values[0] = conf.getDouble(id + ".low");
        this.values[1] = conf.getDouble(id + ".threshold");
        this.values[2] = conf.getDouble(id + ".high");
        this.count = -1;
    }

    @Override
    public void reset() {
        this.count = -1;
    }

    @Override
    public boolean hasMoreChoices() {
        return !this.isDone && this.count < 2;
    }

    @Override
    public Double getNextChoice() {
        if (this.count >= 0) {
            return new Double(this.values[this.count]);
        }
        return new Double(this.values[0]);
    }

    @Override
    public void advance() {
        if (this.count < 2) {
            ++this.count;
        }
    }

    @Override
    public int getTotalNumberOfChoices() {
        return 3;
    }

    @Override
    public int getProcessedNumberOfChoices() {
        return this.count + 1;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("[id=\"");
        sb.append(this.id);
        sb.append("\",");
        for (int i = 0; i < 3; ++i) {
            if (this.count == i) {
                sb.append('>');
            }
            sb.append(this.values[i]);
            if (this.count >= 2) continue;
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }

    public DoubleThresholdGenerator randomize() {
        for (int i = this.values.length - 1; i > 0; --i) {
            int j = random.nextInt(i + 1);
            double tmp = this.values[i];
            this.values[i] = this.values[j];
            this.values[j] = tmp;
        }
        return this;
    }
}

