/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.choice;

import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.StaticElementInfo;
import gov.nasa.jpf.jvm.ThreadInfo;

public class DoubleSpec {
    public static double eval(String spec) {
        double ret;
        char c = spec.charAt(0);
        if (Character.isDigit(c) || c == '+' || c == '-' || c == '.') {
            try {
                ret = Double.parseDouble(spec);
            }
            catch (NumberFormatException nfx) {
                throw new JPFException("illegal double spec: " + spec);
            }
        } else {
            ret = DoubleSpec.resolveVar(spec);
        }
        return ret;
    }

    public static double resolveVar(String spec) {
        double ret;
        JVM vm = JVM.getVM();
        String[] varId = spec.split("[.]+");
        switch (varId.length) {
            case 1: {
                ThreadInfo ti = ThreadInfo.getCurrentThread();
                try {
                    ret = ti.getDoubleLocal(varId[0]);
                }
                catch (JPFException e) {
                    int id = ti.getThis();
                    if (id >= 0) {
                        Object ei = vm.getDynamicArea().get(id);
                        ret = ((ElementInfo)ei).getDoubleField(varId[0]);
                        break;
                    }
                    ClassInfo ci = ti.getMethod().getClassInfo();
                    StaticElementInfo ei = vm.getKernelState().sa.get(ci.getName());
                    ret = ei.getDoubleField(varId[0]);
                }
                break;
            }
            case 2: {
                ClassInfo ci = ClassInfo.getClassInfo(varId[0]);
                StaticElementInfo ei = vm.getStaticArea().get(ci.getName());
                ret = ei.getDoubleField(varId[1]);
                break;
            }
            default: {
                throw new JPFException("Choice value format error parsing \"" + spec + "\"");
            }
        }
        return ret;
    }
}

