/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.InvokeInstruction;

public abstract class VirtualInvocation
extends InvokeInstruction {
    ClassInfo lastCalleeCi;

    protected VirtualInvocation() {
    }

    @Override
    public MethodInfo getInvokedMethod(ThreadInfo ti) {
        int objRef = ti.getNextPC() == null ? ti.getCalleeThis(this.getArgSize()) : this.lastObj;
        return this.getInvokedMethod(ti, objRef);
    }

    @Override
    public Instruction execute(SystemState ss, KernelState ks, ThreadInfo ti) {
        ChoiceGenerator<?> cg;
        int objRef = ti.getCalleeThis(this.getArgSize());
        if (objRef == -1) {
            return ti.createAndThrowException("java.lang.NullPointerException", "calling '" + this.mname + "' on null object");
        }
        MethodInfo mi = this.getInvokedMethod(ti, objRef);
        if (mi == null) {
            return ti.createAndThrowException("java.lang.NoSuchMethodException", ti.getClassInfo(objRef).getName() + "." + this.mname);
        }
        if (mi.isSynchronized() && (cg = this.getSyncCG(objRef, mi, ss, ks, ti)) != null) {
            ss.setNextChoiceGenerator(cg);
            return this;
        }
        return mi.execute(ti);
    }

    public int getThis(ThreadInfo ti) {
        if (!ti.isPostExec()) {
            return ti.getCalleeThis(this.getArgSize());
        }
        return this.lastObj;
    }

    public ElementInfo getThisElementInfo(ThreadInfo ti) {
        int thisRef = this.getThis(ti);
        if (thisRef != -1) {
            return ti.getElementInfo(thisRef);
        }
        return null;
    }

    public MethodInfo getInvokedMethod(ThreadInfo ti, int objRef) {
        if (objRef != -1) {
            this.lastObj = objRef;
            ClassInfo cci = ti.getClassInfo(objRef);
            if (this.lastCalleeCi != cci) {
                this.lastCalleeCi = cci;
                this.invokedMethod = cci.getMethod(this.mname, true);
                if (this.invokedMethod == null) {
                    this.lastObj = -1;
                }
            }
        } else {
            this.lastObj = -1;
            this.invokedMethod = null;
        }
        return this.invokedMethod;
    }

    @Override
    public Object getFieldValue(String id, ThreadInfo ti) {
        int objRef = this.getThis(ti);
        Object ei = ti.getVM().getDynamicArea().get(objRef);
        Object v = ((ElementInfo)ei).getFieldValueObject(id);
        if (v == null) {
            v = ((ElementInfo)ei).getClassInfo().getStaticFieldValueObject(id);
        }
        return v;
    }
}

