/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.IntChoiceGenerator;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.choice.IntIntervalGenerator;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.Select;

public abstract class SwitchInstruction
extends Instruction {
    public static final int DEFAULT = -1;
    protected int target;
    protected int[] targets;
    protected int[] matches;
    protected int lastIdx;

    @Override
    public void setPeer(org.apache.bcel.generic.Instruction i, ConstantPool cp) {
        this.target = ((Select)i).getTarget().getPosition();
        this.matches = ((Select)i).getMatchs();
        int length = this.matches.length;
        this.targets = new int[length];
        InstructionHandle[] ih = ((Select)i).getTargets();
        for (int j = 0; j < length; ++j) {
            this.targets[j] = ih[j].getPosition();
        }
    }

    @Override
    public Instruction execute(SystemState ss, KernelState ks, ThreadInfo ti) {
        int value = ti.pop();
        this.lastIdx = -1;
        int l = this.matches.length;
        for (int i = 0; i < l; ++i) {
            if (value != this.matches[i]) continue;
            this.lastIdx = i;
            return ti.getMethod().getInstructionAt(this.targets[i]);
        }
        return ti.getMethod().getInstructionAt(this.target);
    }

    public Instruction executeAllBranches(SystemState ss, KernelState ks, ThreadInfo ti) {
        if (!ti.isFirstStepInsn()) {
            IntIntervalGenerator cg = new IntIntervalGenerator(0, this.matches.length);
            ss.setNextChoiceGenerator(cg);
            return this;
        }
        ChoiceGenerator<?> cg = ss.getChoiceGenerator();
        assert (cg != null && cg instanceof IntChoiceGenerator) : "expected IntChoiceGenerator, got: " + cg;
        int idx = ti.pop();
        idx = ((IntChoiceGenerator)cg).getNextChoice();
        if (idx == this.matches.length) {
            this.lastIdx = -1;
            return ti.getMethod().getInstructionAt(this.target);
        }
        this.lastIdx = idx;
        return ti.getMethod().getInstructionAt(this.targets[idx]);
    }

    public int getLastTargetIndex() {
        return this.lastIdx;
    }

    public int getNumberOfTargets() {
        return this.matches.length;
    }

    public int getMatchConst(int idx) {
        return this.matches[idx];
    }
}

