/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.StaticElementInfo;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.StaticFieldInstruction;
import gov.nasa.jpf.jvm.bytecode.StoreInstruction;

public class PUTSTATIC
extends StaticFieldInstruction
implements StoreInstruction {
    protected long lastValue;

    public long getLastValue() {
        return this.lastValue;
    }

    @Override
    public Instruction execute(SystemState ss, KernelState ks, ThreadInfo ti) {
        FieldInfo fi = this.getFieldInfo();
        if (fi == null) {
            return ti.createAndThrowException("java.lang.NoSuchFieldException", this.className + '.' + this.fname);
        }
        ClassInfo ci = fi.getClassInfo();
        if (!this.mi.isClinit() && this.requiresClinitCalls(ti, ci)) {
            return ti.getPC();
        }
        StaticElementInfo ei = ks.sa.get(ci.getName());
        if (this.isNewPorFieldBoundary(ti) && this.createAndSetFieldCG(ss, ei, ti)) {
            return this;
        }
        Object attr = null;
        switch (fi.getStorageSize()) {
            case 1: {
                attr = ti.getOperandAttr();
                int ival = ti.pop();
                this.lastValue = ival;
                if (fi.isReference()) {
                    ei.setReferenceField(fi, ival);
                    break;
                }
                ((ElementInfo)ei).setIntField(fi, ival);
                break;
            }
            case 2: {
                long lval;
                attr = ti.getLongOperandAttr();
                this.lastValue = lval = ti.longPop();
                ei.setLongField(fi, lval);
                break;
            }
            default: {
                throw new JPFException("invalid field type");
            }
        }
        ei.setFieldAttrNoClone(fi, attr);
        return this.getNext(ti);
    }

    @Override
    public int getLength() {
        return 3;
    }

    @Override
    public int getByteCode() {
        return 179;
    }
}

