/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.Types;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.ConstantPool;

public class NEWARRAY
extends Instruction {
    protected String type;

    @Override
    public void setPeer(org.apache.bcel.generic.Instruction i, ConstantPool cp) {
        this.type = Constants.SHORT_TYPE_NAMES[((org.apache.bcel.generic.NEWARRAY)i).getTypecode()];
    }

    @Override
    public Instruction execute(SystemState ss, KernelState ks, ThreadInfo ti) {
        int size = ti.pop();
        DynamicArea heap = DynamicArea.getHeap();
        String clsName = "[" + this.type;
        ClassInfo ci = ClassInfo.getClassInfo(clsName);
        if (!ci.isInitialized()) {
            ci.loadAndInitialize(ti);
        }
        if (heap.getOutOfMemory()) {
            return ti.createAndThrowException("java.lang.OutOfMemoryError", "trying to allocate new " + Types.getTypeName(this.type) + "[" + size + "]");
        }
        int arrayRef = heap.newArray(this.type, size, ti);
        ti.push(arrayRef, true);
        ss.checkGC();
        return this.getNext(ti);
    }

    @Override
    public int getLength() {
        return 2;
    }

    @Override
    public int getByteCode() {
        return 188;
    }
}

