/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import org.apache.bcel.classfile.ConstantPool;

public class NEW
extends Instruction {
    protected String cname;

    @Override
    public void setPeer(org.apache.bcel.generic.Instruction i, ConstantPool cp) {
        this.cname = cp.constantToString(cp.getConstant(((org.apache.bcel.generic.NEW)i).getIndex()));
    }

    @Override
    public Instruction execute(SystemState ss, KernelState ks, ThreadInfo ti) {
        JVM vm = ti.getVM();
        DynamicArea da = vm.getDynamicArea();
        ClassInfo ci = ClassInfo.getClassInfo(this.cname);
        if (ci == null) {
            return ti.createAndThrowException("java.lang.NoClassDefFoundError", this.cname);
        }
        if (!ci.isInitialized() && ci.loadAndInitialize(ti, this) > 0) {
            return ti.getPC();
        }
        if (da.getOutOfMemory()) {
            return ti.createAndThrowException("java.lang.OutOfMemoryError", "trying to allocate new " + this.cname);
        }
        int objRef = da.newObject(ci, ti);
        ti.push(objRef, true);
        ss.checkGC();
        return this.getNext(ti);
    }

    @Override
    public int getLength() {
        return 3;
    }

    @Override
    public int getByteCode() {
        return 187;
    }
}

